<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Cyber Security Service</title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('build/assets/app-3ea8b221.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/mobile.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('css/owl.carousel.min.css')); ?>">


</head>
<body>


<!-- HEADER-SECTION -->
<?php if(auth()->guard()->check()): ?>
<div class="top-header d-flex align-items-center" style="min-height: 75px; background: #171d34">
    <div class="container">
        <div class="text-white text-end">
           Welcome back, &nbsp
                <strong>
                     <a class="navbar-brand p-2 border rounded-3" href="<?php echo e(route('dashboard')); ?>"> <?php echo e(auth()->user()->name); ?>&nbsp  <i class="fa-xl fa-solid fa-user-secret"></i> </a>
                </strong>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="home-header-section">
    <figure class="banner-right-img left_icon img">
        <img src="<?php echo e(asset('images/header-right-img.png')); ?>" alt="" class="star">
    </figure>
    <header class="header">
        <div class="main-header">
            <div class="container">
                <nav class="navbar navbar-expand-lg navbar-light p-0 ">
                    <a class="navbar-brand pt-0" href="<?php echo e(route('home.index')); ?>"><img src="<?php echo e(asset('images/whiz-cyber-logo.png')); ?>" alt="" class="img-fluid diverge-logo"></a>
                    <button class="navbar-toggler collapsed" type="button" data-toggle="collapse"
                            data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                            aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                        <span class="navbar-toggler-icon"></span>
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav align-items-center">
                            <li class="nav-item active">
                                <a class="nav-link text-decoration-none navbar-text-color home-margin-top" href="<?php echo e(route('home.index')); ?>">Home<span class="sr-only">(current)</span></a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link text-decoration-none navbar-text-color" href="#">About us</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link text-decoration-none navbar-text-color" href="#">Services</a>
                            </li>
                            <?php if(Route::has('login')): ?>
                                <?php if(auth()->guard()->check()): ?>
                                    <div class="btn-talk ml-auto">
                                        <ul class="m-0 p-0">
                                            <li class="list-unstyled d-lg-inline-block"><a class="nav-link contact" href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                                        </ul>
                                    </div>
                                    <li class="nav-item">
                                        <a class="list-unstyled d-lg-inline-block" tabindex="-1" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                           document.getElementById('logout-form').submit();">Logout
                                        </a>
                                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                            <?php echo csrf_field(); ?>
                                        </form>
                                    </li>
                                <?php else: ?>
                                    <li class="nav-item">
                                        <a class="nav-link text-decoration-none navbar-text-color"  href="<?php echo e(route('login')); ?>">Login</a>
                                    </li>

                        </ul>
                        <?php if(Route::has('register')): ?>
                            <div class="btn-talk ml-auto">
                                <ul class="m-0 p-0">
                                    <li class="list-unstyled d-lg-inline-block"><a class="nav-link contact" href="<?php echo e(route('register')); ?>">Register</a></li>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <?php endif; ?>
                        <?php endif; ?>

                    </div>
                </nav>
            </div>
        </div>
    </header>
    <!-- BANNER-SECTION -->
    <div class="home-banner-section overflow-hidden position-relative">
        <div class="banner-container-box">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-xl-6 col-lg-7 col-md-12 col-sm-12 mb-md-0 mb-4 text-md-left text-center order-lg-1 order-2">
                        <div class="social-icons position-absolute">
                            <ul class="list-unstyled">
                                <li><a class="text-decoration-none"><i class="fa-brands fa-facebook-f social-networks"></i></a></li>
                                <li><a class="text-decoration-none"><i class="fa-brands fa-twitter social-networks"></i></a></li>
                                <li><a class="text-decoration-none"><i class="fa-brands fa-instagram social-networks"></i></a></li>
                            </ul>
                        </div>
                        <div class="home-banner-text" data-aos="fade-up" id="myContentDIV">
                            <h1>We Provide <span class="h1-text">Cyber Solutions</span> For Your Security</h1>
                            <p class="banner-paragraph">
                                Quis autem vel eum iure reprehenderit qui in ea voluptate
                                velit esse ruam nihil molestiae.</p>
                            <div class="banner-btn discover-btn-banner">
                                <a href="about.html" class="text-decoration-none">Get Started</a>
                                <a href="about.html" class="text-decoration-none play-button">Contact us</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-5 col-md-12 col-sm-12 order-lg-2 order-1">
                        <div class="banner-img-content position-relative">
                            <figure class="banner-img mb-0">
                                <img class="img-fluid banner-img-width" src="<?php echo e(asset('images/whiz-cyber-banner.png')); ?>" alt="">
                            </figure>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="footer-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-6">

            </div>
            <div class="col-lg-2 col-md-2 col-sm-12 d-lg-block d-none">

            </div>
            <div class="col-lg-3 col-md-4 col-sm-12 d-md-block d-none">

            </div>
            <div class="col-lg-3 col-md-4 col-sm-6">

            </div>
        </div>
    </div>
    <div class="footer-bar text-center">
        <div class="row">
            <div class="footer-bar-content w-100">
                <p class="text-size-16 mb-0">Whizcyber copyright © 2022. All Rights Reserved.</p>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-1.12.1.min.js"></script>
<script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/animations.js')); ?>"></script>
<script src="<?php echo e(asset('js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/owl.carousel.js')); ?>"></script>
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script src="<?php echo e(asset('js/text-animations.js')); ?>"></script>
<script src="<?php echo e(asset('js/carousel.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.js"></script>
<script src="https://unpkg.com/ityped@0.0.10"></script>
<script src="<?php echo e(asset('js/type.js')); ?>"></script>
<script src="<?php echo e(asset('js/custom-script.js')); ?>"></script>

</body>
</html>
<?php /**PATH /Users/owl/server/api-servise/resources/views/welcome.blade.php ENDPATH**/ ?>