<?php $__env->startSection('title'); ?>
    Панель Управления U13| Пользователи
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('parts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="user-table mt-5">
    <table id="example" class="display" style="width:100%">
        <thead>
        <tr>
            <th>ID</th>
            <th>ФИО</th>
            <th>Тип</th>
            <th>Email</th>
            <th>Телефон</th>
            <th>Аватар</th>
            <th>Дата Регистрации</th>
            <th>Действия</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($user->id); ?></td>
                <td><?php echo e($user->surname); ?> <?php echo e($user->name); ?> <?php echo e($user->middle_name); ?></td>
                <td>
                    <?php if($user->role == 'individual'): ?>
                    Физ.лицо
                    <?php elseif($user->role == 'entity'): ?>
                    Юр.лицо
                    <?php else: ?>
                    <b class="text-danger">Администратор</b>
                    <?php endif; ?>
                </td>
                <td><?php echo e($user->email); ?></td>
                <td><?php echo e($user->phone); ?></td>
                <td>
                    <?php if($user->avatar != null): ?>
                    <img src="<?php echo e($user->avatar); ?>" style="width: 80px; height: 80px" alt="avatar">
                    <?php else: ?>
                        <img src="<?php echo e(asset('images/admin/empty.jpg')); ?>" style="width: 80px; height: 80px" alt="">
                    <?php endif; ?>
                </td>
                <td><?php echo e($user->created_at); ?></td>
                <td>
                    <div class="d-block w-100 ">
                        <a><i class='bx bx-edit-alt p-2 user-edit-btn' style="font-size: 22px"></i></a>
                        <form method="post" class="d-inline-block m-2" id="user-delete-<?php echo e($user->id); ?>"
                              action="<?php echo e(route('user.delete',$user->id)); ?>">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <a href="<?php echo e(route('user.delete', $user->id)); ?>" onclick="event.preventDefault();
                                     document.getElementById('user-delete-<?php echo e($user->id); ?>').submit();">
                                <i class='bx bxs-message-square-x  p-2 user-delete-btn' style="font-size: 22px"></i>
                            </a>
                              <button type="submit" class="d-none"></button>

                        </form>
                    </div>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
        <tfoot>
        <tr>

        </tr>
        </tfoot>
    </table>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-scripts-footer'); ?>
    <script>
        $(document).ready(function () {
            $('#example').DataTable({
                pagingType: 'full_numbers',
                "language": {
                    "search": "Поиск",
                    paginate: {
                        first:      "Первая",
                        last:       "Последняя",
                        previous: '<<',
                        next:     '>>'
                    },
                    "info":           "Показано _END_ из _TOTAL_ результатов",
                    "infoFiltered":   "(Отфильтровано из _MAX_ total результатов)",
                    "infoPostFix":    "",
                    "lengthMenu":     "Показать _MENU_ результатов",
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/app/resources/views/admin/users/index.blade.php ENDPATH**/ ?>