<?php $__env->startSection('title'); ?>
    Панель Управления U13| Cчета
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-head-scripts'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('libs/lightbox/css/lightbox.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <div class="col-xl-3 col-md-6">
                <!-- card -->
                <div class="card card-animate">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1 overflow-hidden">
                                <?php if($user->role != 'admin'): ?>
                                <p class="text-uppercase fw-medium fw-bold text-muted text-truncate mb-0"><?php echo e($user->surname); ?> <?php echo e($user->name); ?></p>
                                <?php else: ?>
                                <p class="text-uppercase fw-medium fw-bold text-danger text-truncate mb-0"><?php echo e($user->surname); ?> <?php echo e($user->name); ?></p>
                                <?php endif; ?>

                            </div>

                            <?php
                                $invoiceSum = DB::table('invoices')->where('user_id', $user->id)->pluck('amount')->sum();
                            ?>
                            <div class="flex-shrink-0">

                                <?php if($invoiceSum >= 0): ?>
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i> +<?php echo e($invoiceSum); ?> ₽
                                    </h5>
                                <?php else: ?>
                                    <h5 class="text-danger fs-14 mb-0">
                                        <i class="ri-arrow-right-down-line fs-13 align-middle"></i> <?php echo e($invoiceSum); ?> ₽
                                    </h5>
                                <?php endif; ?>

                            </div>
                        </div>
                        <div class="d-flex align-items-end justify-content-between mt-4">
                            <div>

                                <h4 class="fs-14 text-warning fw-semibold ff-secondary mb-4">
                                    Cчетов:
                                    <span class="counter-value" data-target="<?php echo e($user->invoices->count()); ?>">0</span>
                                </h4>

                                <a href="#" class="text-decoration-underline"
                                   data-bs-toggle="modal"
                                   data-bs-target="#invoices-<?php echo e($user->id); ?>">
                                    Посмотреть все
                                </a>
                            </div>
                            <div class="avatar-sm flex-shrink-0">
                                 <span class="avatar-title bg-soft-success rounded fs-3">
                                     <?php
                                         preg_match('/[^\/]+\.[^.]+$/', $user->avatar, $matches);

                                     ?>
                                     <a href="<?php echo e($user->avatar); ?>" data-lightbox="<?php echo e($matches[0]); ?>">
                                     <img src="<?php echo e($user->avatar); ?>" width="70" height="70" >
                                     </a>
                                 </span>
                            </div>
                        </div>
                    </div><!-- end card body -->
                </div><!-- end card -->

                <!-- Modal -->
                <div class="modal fade" id="invoices-<?php echo e($user->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-scrollable modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><?php echo e($user->name); ?> <?php echo e($user->surname); ?> | Все счета </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <table class="table table-striped">
                                    <thead>
                                    <tr>
                                        <th scope="col">#ID</th>
                                        <th scope="col">Отправитель</th>
                                        <th scope="col">Категория</th>
                                        <th scope="col">Сообщение</th>
                                        <th scope="col">Период</th>
                                        <th scope="col">Сумма</th>
                                        <th scope="col">Просмотрено</th>
                                    </tr>
                                    </thead>
                                    <tbody >
                                    <?php $__currentLoopData = $user->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <th scope="row"><?php echo e($invoice->id); ?></th>
                                        <td class="table-info"><?php echo e($invoice->sender); ?></td>
                                        <td class="table-warning"><?php echo e($invoice->category->name); ?></td>
                                        <td><?php echo e($invoice->message); ?></td>
                                        <td></td>

                                        <?php if($invoice->amount < 0): ?>
                                            <td class="text-danger ">
                                                <?php echo e($invoice->amount); ?> руб.
                                        <?php else: ?>
                                            <td class="text-success ">
                                                +<?php echo e($invoice->amount); ?> руб.
                                            <?php endif; ?>
                                        </td>

                                            <?php if($invoice->visited): ?>
                                            <td class="table-success text-center">
                                               <span class="">Да</span>
                                            <?php else: ?>
                                            <td class="table-danger text-center">
                                                <span class="">Нет</span>
                                            <?php endif; ?>

                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="modal-footer">

                            </div>
                        </div>
                    </div>
                </div>
                <!--End Modal -->

            </div><!-- end col -->

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php echo e($users->onEachSide(5)->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-scripts-footer'); ?>
    <script src="<?php echo e(asset('libs/lightbox/js/lightbox.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/app/resources/views/admin/invoices/index.blade.php ENDPATH**/ ?>