<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\AuthErrorController;
use App\Http\Controllers\ServiceApplicationsController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\PropertyController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/auth-err', AuthErrorController::class)->name('auth-error');

Route::get('/dashboard/test', [\App\Http\Controllers\Api\TestController::class, 'test_web'])->name('test_web');

Route::group(['middleware' => 'auth', 'prefix' => 'dashboard'], function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::delete('/user-delete/{id}', [UserController::class, 'destroy'])->name('user.delete');

    Route::get('/invoices', [InvoiceController::class, 'index'])->name('invoice.index');
    Route::get('/invoices/create', [InvoiceController::class, 'create'])->name('invoice.create');
    Route::post('/invoices/store', [InvoiceController::class, 'store'])->name('invoice.store');

    Route::get('/services-applications', [ServiceApplicationsController::class, 'index'])->name('services-applications.index');
    Route::put('/services-application/edit/{id}', [ServiceApplicationsController::class, 'update'])->name('services-applications.update');
    Route::delete('/services-application/delete/{id}', [ServiceApplicationsController::class, 'destroy'])->name('services-applications.delete');
    Route::put('/services-application/change-status/accept', [ServiceApplicationsController::class, 'acceptApplicationFromSidePanel'])->name('accept-application-from-side-panel');
    Route::put('/services-application/change-status/cancel', [ServiceApplicationsController::class, 'cancelApplicationFromSidePanel'])->name('cancel-application-from-side-panel');
    Route::delete('/services-application/change/delete', [ServiceApplicationsController::class, 'deleteApplicationFromSidePanel'])->name('delete-application-from-side-panel');


    Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');
    Route::get('/notifications/user/{id}', [NotificationController::class, 'getNotificationsByUserId'])->name('notifications.user');
    Route::post('/notification/store', [NotificationController::class, 'store'])->name('notification.store');
    Route::delete('/notification/delete/{id}', [NotificationController::class, 'destroy'])->name('notification.delete');
    Route::put('/notification/edit', [NotificationController::class, 'edit'])->name('notification.edit');

    Route::get('/properties', [PropertyController::class, 'index'])->name('property.index');
    Route::get('/property/{id}', [PropertyController::class, 'show'])->name('property.show');
    Route::delete('/property-statuses/delete/{user_id}/{property_id}', [PropertyController::class, 'deleteUserStatusesFromProperty'])->name('delete-user-statuses-from-property');
    Route::put('/property-status-accept/{id}', [PropertyController::class, 'acceptRequest'])->name('property-status-accept');
    Route::post('/property/add-new-user', [PropertyController::class, 'addNewUser'])->name('property.add-new-user');
});

Route::get('/', [\App\Http\Controllers\HomeController::class, 'index'])->name('home.index');

Auth::routes();

