<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\TestController;
use App\Http\Controllers\Api\InvoiceController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Api\ServiceApplicationsController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\PropertyController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

    Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
        return $request->user();
    });
    Route::middleware('auth:sanctum')->post('auth/check', [AuthController::class, 'checkAuth'])
    ->name('auth.check');

    Route::group(['prefix' => 'auth',], function () {

        Route::post('/register-api', [AuthController::class, 'createUser'])->name('api.register');
        Route::post('/login-api', [AuthController::class, 'loginUser'])->name('api.login');
        Route::post('/logout-api', [AuthController::class, 'logoutUser'])->name('api.logout-api');
    });

    Route::post('/save-fcm-token', [UserController::class, 'saveFcmToken'])->name('save-fcm-token');

    Route::group(['middleware' => 'auth:sanctum'], function (){

        Route::post('/invoices', [InvoiceController::class, 'getUserInvoices'])->name('api.invoices');
        Route::post('/invoices/last/{count}', [InvoiceController::class, 'getLastUserInvoices'])->name('api.invoices.last');
        Route::post('/invoice/show/{id}', [InvoiceController::class, 'show'])->name('invoice.show');
        Route::post('/invoice/set-visited/{id}', [InvoiceController::class, 'setVisited'])->name('invoice.set-visited');
        Route::put('/user/update', [UserController::class, 'update_API'])->name('user.update');
        Route::put('/user/password/change', [UserController::class, 'passwordChange_API'])->name('user.password.change');
        Route::post('/get-applications-categories', [ServiceApplicationsController::class, 'getCategories'])->name('get-applications-categories');
        Route::post('/applications/store', [ServiceApplicationsController::class, 'store'])->name('applications.store');
        Route::post('/applications/get', [ServiceApplicationsController::class, 'getUserApplications'])->name('applications.get');
        Route::post('/applications/cancel', [ServiceApplicationsController::class, 'cancelApplication'])->name('applications.cancel');
        Route::post('/application/show/{id}', [ServiceApplicationsController::class, 'showApplication'])->name('application.show');
        Route::put('/application/edit/{id}', [ServiceApplicationsController::class, 'editApplication'])->name('application.edit');
        Route::post('/notifications/get', [NotificationController::class, 'getNotifications'])->name('notifications-get');
        Route::post('/notification/{id}', [NotificationController::class, 'getNotificationById'])->name('get-notification-by-id');
        Route::post('/notification/set-visited/{id}', [NotificationController::class, 'setVisited'])->name('notification.set-visited');
        Route::post('/notifications/count', [NotificationController::class, 'getNotificationsCount'])->name('get-notifications-count');
        Route::post('/notifications/delete', [NotificationController::class, 'destroy'])->name('notifications.delete');
        Route::post('/objects/get', [PropertyController::class, 'getUserObjects'])->name('property.get-user-objects');
        Route::post('/objects/all', [PropertyController::class, 'getAllObjects'])->name('property.get-all-objects');
        Route::post('/objects/get-all-statuses', [PropertyController::class, 'getAllStatuses'])->name('property.get-all-statuses');
        Route::post('/objects/get-all-additional-statuses', [PropertyController::class, 'getAllAdditionalStatuses'])->name('property.get-all-additional-statuses');
        Route::post('/objects/add-new', [PropertyController::class, 'addNewObject'])->name('property.add-new-object');
        Route::post('/object/get/{id}', [PropertyController::class, 'getObjectById'])->name('property.get-object-by-id');

    });

    Route::get('/posts', [TestController::class, 'test'])->middleware('auth:sanctum');

