@extends('layouts.app')

@section('title')
    Панель Управления | u13 Controller
@endsection

@section('custom-head-scripts')
    <style>
        .ribbon-changed {
            animation: flashing 1s infinite;
        }
        .changed{
            background: rgba(162, 99, 204, 0.69);
            animation: flashing 1s infinite;
        }
        @keyframes  flashing{
            50% {
                opacity: 0.15;
            }
        }
    </style>
@endsection

@section('content')

    <div class="row">
        <div class="col">

            <div class="h-100">
                @include('parts.messages')
                <div class="row mb-3 pb-1">
                    <div class="col-12">
                        <div class="d-flex align-items-lg-center flex-lg-row flex-column">
                            <div class="flex-grow-1">
                                <h4 class="fs-16 mb-1">Здравствуйте, {{auth()->user()->name}}</h4>
                                <p class="text-muted mb-0">Здесь собраны последние данные на сегодняшний день</p>
                            </div>
                            <div class="mt-3 mt-lg-0">
                                <div class="row g-3 mb-0 align-items-center">
                                    <div class="col-sm-auto">
                                        <div class="input-group">
                                            <input type="text" class="form-control border-0 dash-filter-picker shadow"
                                                   data-provider="flatpickr" readonly value="{{\Carbon\Carbon::now()}}">
                                            <div class="input-group-text bg-primary border-primary text-white">
                                                <i class="ri-calendar-2-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--end row-->
                            </div>
                        </div><!-- end card header -->
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->

                <div class="row">
                    <div class="col-xl-3 col-md-6">
                        <!-- card -->
                        <div class="card card-animate">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1 overflow-hidden">
                                        <p class="text-uppercase fw-medium text-muted text-truncate mb-0">
                                            Пользователи</p>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <h5 class="text-success fs-14 mb-0">
                                            <i class="ri-arrow-right-up-line fs-13 align-middle"></i> +16.24 %
                                        </h5>
                                    </div>
                                </div>
                                <div class="d-flex align-items-end justify-content-between mt-4">
                                    <div>
                                        <h4 class="fs-22 fw-semibold ff-secondary mb-4"><span class="counter-value"
                                                                                              data-target="{{\App\Models\User::count()}}">0</span>
                                        </h4>
                                        <a href="{{ route('users.index') }}" class="text-decoration-underline">Посмотреть
                                            список</a>
                                    </div>
                                    <div class="avatar-sm flex-shrink-0">
                                                        <span class="avatar-title bg-soft-success rounded fs-3">
                                                            <i class="bx bx-user-circle text-success"></i>
                                                        </span>
                                    </div>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    <div class="col-xl-3 col-md-6">
                        <!-- card -->
                        <div class="card card-animate">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1 overflow-hidden">
                                        <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Счета</p>
                                    </div>

                                    @php
                                        $invoicesSum = DB::table('invoices')->pluck('amount')->sum();
                                    @endphp

                                    <div class="flex-shrink-0">
                                            @if($invoicesSum < 0)

                                                <h5 class="text-danger fs-14 mb-0">
                                                    <i class="ri-arrow-right-down-line fs-13 align-middle"></i> {{$invoicesSum}} ₽
                                            @else
                                                 <h5 class="text-success fs-14 mb-0">
                                                    <i class="ri-arrow-right-up-line fs-13 align-middle"></i> {{$invoicesSum}} ₽
                                            @endif

                                        </h5>
                                    </div>
                                </div>

                                <div class="d-flex align-items-end justify-content-between mt-4">
                                    <div>
                                        <h4 class="fs-22 fw-semibold ff-secondary mb-4"><span class="counter-value"
                                                                                              data-target="{{\App\Models\Invoice::count()}}">0</span>
                                        </h4>
                                        <a href="{{route('invoice.index')}}" class="text-decoration-underline">Просмотр счетов</a>
                                    </div>
                                    <div class="avatar-sm flex-shrink-0">
                                                        <span class="avatar-title bg-soft-info rounded fs-3">
                                                            <i class="bx bx-dollar text-info"></i>
                                                        </span>
                                    </div>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    <div class="col-xl-3 col-md-6">
                        <!-- card -->
                        <div class="card card-animate">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1 overflow-hidden">
                                        <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Обращения</p>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <h5 class="text-success fs-14 mb-0">
                                            <i class="ri-arrow-right-up-line fs-13 align-middle"></i> +29.08 %
                                        </h5>
                                    </div>
                                </div>
                                <div class="d-flex align-items-end justify-content-between mt-4">
                                    <div>
                                        <h4 class="fs-22 fw-semibold ff-secondary mb-4"><span class="counter-value"
                                                                                              data-target="{{\App\Models\Application::count()}}">0</span> заявок
                                        </h4>
                                        <a href="{{route('services-applications.index')}}" class="text-decoration-underline">Смотреть все</a>
                                    </div>
                                    <div class="avatar-sm flex-shrink-0">
                                                        <span class="avatar-title bg-soft-warning rounded fs-3">
                                                            <i class="bx bxs-file-blank text-warning"></i>
                                                        </span>
                                    </div>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    <div class="col-xl-3 col-md-6">
                        <!-- card -->
                        <div class="card card-animate">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1 overflow-hidden">
                                        <p class="text-uppercase fw-medium text-muted text-truncate mb-0"> Исходящие уведомления </p>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <h5 class="text-muted fs-14 mb-0">
{{--                                            +0.00 %--}}
                                        </h5>
                                    </div>
                                </div>
                                <div class="d-flex align-items-end justify-content-between mt-4">
                                    <div>
                                        <h4 class="fs-22 fw-semibold ff-secondary mb-4"><span class="counter-value"
                                                                                               data-target="{{\App\Models\Notification::count()}}">0</span>
                                        </h4>
                                        <a href="{{route('notifications.index')}}" class="text-decoration-underline">Смотреть все</a>
                                    </div>
                                    <div class="avatar-sm flex-shrink-0">
                                        <span class="avatar-title bg-soft-primary rounded fs-3">
                                            <i class="bx bx-notification text-primary"></i>
                                        </span>
                                    </div>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->
                </div> <!-- end row-->

                <div class="row">
                    <div class="col-xl-8">
                        <div class="card">
                            <div class="card-header border-0 align-items-center d-flex">
                                <h4 class="card-title mb-0 flex-grow-1">Запросы на добавление объекта</h4>

                            </div><!-- end card header -->

                            <div class="card-header p-0 border-0 bg-soft-light">
                                <div class="row g-0 text-center">
                                    <div class="col-6 col-sm-3">
                                        <div class="p-3 border border-dashed border-start-0">
                                            <h5 class="mb-1"><span class="counter-value" data-target="{{\App\Models\PropertyStatus::count() + \App\Models\PropertyAdditionalStatuses::count()}}">0</span>
                                            </h5>
                                            <p class="text-muted mb-0">Всего</p>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-6 col-sm-3">
                                        <div class="p-3 border border-dashed border-start-0">
                                            <h5 class="mb-1"><span class="counter-value"
                                                                    data-target="{{\App\Models\PropertyStatus::count()}}">0</span></h5>
                                            <p class="text-muted mb-0">Общие статусы</p>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-6 col-sm-3">
                                        <div class="p-3 border border-dashed border-start-0">
                                            <h5 class="mb-1"><span class="counter-value" data-target="{{\App\Models\PropertyAdditionalStatuses::count()}}">0</span>
                                            </h5>
                                            <p class="text-muted mb-0">Доп.статусы</p>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-6 col-sm-3">
                                        <div class="p-3 border border-dashed border-start-0 border-end-0">
                                            <h5 class="mb-1 text-success">
                                                <span class="counter-value"
                                                      data-target="{{\App\Models\PropertyStatus::where('approved', 0)->count()}}">0</span>
                                            </h5>
                                           <p class="text-muted mb-0"> <i class="bx bxs-bell-plus text-danger bx-tada"></i> Новые запросы</p>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                            </div><!-- end card header -->

                            <div class="card-body p-0 pb-2">

                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    <div class="col-xl-4">
                        <!-- card -->
                        <div class="card card-height-100">

                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>

                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header align-items-center d-flex">
                                <h4 class="card-title mb-0 flex-grow-1">Последние счета</h4>
                                <div class="flex-shrink-0">

                                </div>
                            </div><!-- end card header -->

                            <div class="card-body">
                                <div class="table-responsive table-card">
                                    <table class="table table-hover table-centered align-middle table-nowrap mb-0">
                                        <tbody>
                                        @foreach($invoices as $invoice)

                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar-sm bg-light rounded p-1 me-2">
                                                        <img src="{{$invoice->category->categoryImage}}" alt=""
                                                             class="img-fluid d-block">
                                                    </div>
                                                    <div>
                                                        <h5 class="fs-14 my-1"><a
                                                                    href="apps-ecommerce-product-details.html"
                                                                    class="text-reset">Оплата счетов за <b>{{$invoice->category->name}}</b></a></h5>
                                                        <span class="text-muted">Период: {{$invoice->period}}</span>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
                                                <h5 class="fs-14 my-1 fw-normal">{{$invoice->user->surname}} {{$invoice->user->name}} {{$invoice->user->middle_name}}</h5>
                                                <span class="text-muted"><i class="bx bx-user-circle"></i> Получатель</span>
                                            </td>

                                            <td>
                                                <h5 class="fs-14 my-1 fw-normal">{{$invoice->created_at}}</h5>
                                                <span class="text-muted">Дата отправки</span>
                                            </td>
                                            <td class="text-center">
                                                @if($invoice->visited)
                                                    <h5 class="fs-14 my-1 fw-normal "><i class="bx bx-check-circle text-success"></i></h5>
                                                @else
                                                    <h5 class="fs-14 my-1 fw-normal "><i class="bx bx-x-circle text-danger"></i></h5>
                                                @endif
                                                <span class="text-muted ">Просмотрено?</span>
                                            </td>

                                            <td>
                                                <h5 class="fs-14 my-1 fw-normal">{{$invoice->resourceValue}} {{$invoice->unit}}</h5>
                                                <span class="text-muted">Потреблено</span>
                                            </td>
                                            <td>
                                                @if($invoice->amount > 0)
                                                    <h5 class="fs-14 my-1 text-success fw-normal">+{{$invoice->amount}}₽</h5>
                                                @else
                                                    <h5 class="fs-14 my-1 text-danger fw-normal">{{$invoice->amount}}₽</h5>
                                                @endif
                                                <span class="text-muted">Итого</span>
                                            </td>
                                        </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <div class="align-items-center mt-4 pt-2 justify-content-end row text-center ">
                                    <div class="d-inline">
                                        <a class="text-muted" href="{{route('invoice.index')}}">Смотреть все</a>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- end row-->

            </div> <!-- end .h-100-->

        </div> <!-- end col -->

        <div class="col-auto layout-rightside-col">
            <div class="overlay"></div>
            <div class="layout-rightside">
                <div class="card h-100 rounded-0">
                    <div class="card-body p-0">
                        <div class="p-3 mt-2">
                            <h6 class="text-muted mb-3 text-uppercase fw-semibold">Последние активные обращения:</h6>
                            <ol class="ps-3 text-muted">
                                @foreach($applications as $application)


                                    <div class="card mb-1 ribbon-box ribbon-fill ribbon-sm mb-2">
                                        @if($application->status === 'Изменена')
                                            <div class="ribbon ribbon-changed" style="background: #c281e3">
                                                <i class="ri-flashlight-fill fs-14 font-weight-bold"></i>
                                            </div>
                                        @elseif($application->status === 'Новая')
                                            <div class="ribbon ribbon-dark">
                                                <i class="bx bxs-bell-plus ty fs-14"></i>
                                            </div>
                                        @elseif($application->status === 'Принята')
                                            <div class="ribbon ribbon-info">
                                                <i class="bx bx-message-add fs-14"></i>
                                            </div>
                                        @elseif($application->status === 'Обработка')
                                            <div class="ribbon ribbon-warning">
                                                <i class="bx bx-time fs-14"></i>
                                            </div>
                                        @endif

                                        @if($application->status === 'Отменена')
                                                <div class="card-body" style="opacity: 0.5">
                                        @else
                                                <div class="card-body">
                                        @endif
                                            <a class="d-flex align-items-center" data-bs-toggle="collapse" href="#offerAccepted2-{{$application->id}}" role="button" aria-expanded="false" aria-controls="offerAccepted2">
                                                <div class="flex-shrink-0">
                                                    <img src="{{$application->applicationCategory->image}}" alt="" class="avatar-xs rounded-circle">
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <h6 class="fs-14 mb-1">{{$application->applicationCategory->name}}</h6>
                                                    <p class="text-muted mb-0">от: {{$application->user->surname}} {{$application->user->name}}</p>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="collapse border-top border-top-dashed" id="offerAccepted2-{{$application->id}}">
                                            <div class="card-body">
                                                <h6 class="fs-14 mb-1">{{$application->applicationCategory->name}} <small class="badge badge-soft-warning">{{$application->applicationCategory->servicePriority}}</small></h6>
                                                <p class="text-muted">{{$application->message}}</p>
                                                <ul class="list-unstyled vstack gap-2 mb-0">
                                                    <li>
                                                        <div class="d-flex">
                                                            <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                <i class="bx bx-user-circle"></i>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <h6 class="mb-0">{{$application->user->surname}} {{$application->user->name}} {{$application->user->middle_name}}</h6>
                                                                <small class="text-muted"> ФИО клиента</small>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="d-flex">
                                                            <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                <i class="bx bx-phone"></i>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <h6 class="mb-0">{{$application->user->phone}}</h6>
                                                                <small class="text-muted">Телефон</small>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="d-flex">
                                                            <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                <i class="bx bx-mail-send"></i>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <h6 class="mb-0">{{$application->user->email}}</h6>
                                                                <small class="text-muted">Email</small>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="d-flex">
                                                            <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                <i class="bx bx-calendar"></i>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                <h6 class="mb-0">{{$application->due_date}}</h6>
                                                                <small class="text-muted">Выполнить</small>
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="d-flex">
                                                            <div class="flex-shrink-0 avatar-xxs text-muted">
                                                                <i class="bx bx-stats"></i>
                                                            </div>
                                                            <div class="flex-grow-1">
                                                                @if($application->status == 'Отменена')
                                                                    <span class="badge float-end badge-soft-warning bg-danger text-uppercase text-white">
                                                                        {{$application->status}}
                                                                    </span>
                                                                @elseif($application->status == 'Новая')
                                                                    <span class="badge float-end badge-soft-warning bg-dark text-uppercase text-white">
                                                                        {{$application->status}}
                                                                    </span>
                                                                @elseif($application->status == 'Обработка')
                                                                    <span class="badge float-end badge-soft-warning bg-warning text-uppercase text-white">
                                                                        {{$application->status}}
                                                                    </span>
                                                                @elseif($application->status == 'Принята')
                                                                    <span class="badge float-end badge-soft-warning bg-secondary text-uppercase text-white">
                                                                        {{$application->status}}
                                                                    </span>
                                                                @elseif($application->status == 'Выполнена')
                                                                    <span class="badge float-end badge-soft-warning bg-success text-uppercase text-white">
                                                                        {{$application->status}}
                                                                    </span>
                                                                @elseif($application->status == 'Изменена')
                                                                    <span class="badge float-end badge-soft-warning text-uppercase text-white changed">
                                                                        {{$application->status}}
                                                                    </span>
                                                                @endif
                                                                <small class="text-muted">Статус </small>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="card-footer hstack gap-2">

                                                @if($application->status === 'Новая')
                                                    <button class="btn btn-warning btn-sm w-50"><i class="ri-file-2-fill align-bottom me-1"></i> Изменить</button>
                                                    <form action="{{route('accept-application-from-side-panel')}}" method="post">
                                                        @csrf @method('PUT')
                                                        <input type="hidden" name="application_id" value="{{$application->id}}">
                                                        <button type="submit" class="btn btn-info btn-sm w-100"><i class="ri-check-fill align-bottom me-1"></i> Принять </button>
                                                    </form>
                                                @elseif($application->status === 'Отменена')
                                                    <button class="btn btn-warning btn-sm w-50"><i class="ri-file-2-fill align-bottom me-1"></i> Изменить</button>
                                                    <form action="{{route('delete-application-from-side-panel')}}" method="post">
                                                        @csrf @method('DELETE')
                                                        <input type="hidden" name="application_id" value="{{$application->id}}">
                                                        <button type="submit" class="btn btn-danger btn-sm w-100"><i class="ri-delete-back-2-fill align-bottom me-1"></i> Удалить </button>
                                                    </form>
                                                @elseif($application->status === 'Изменена')
                                                    <form action="{{route('accept-application-from-side-panel')}}" method="post">
                                                        @csrf @method('PUT')
                                                        <input type="hidden" name="application_id" value="{{$application->id}}">
                                                        <button class="btn btn-success btn-sm w-100"><i class="ri-file-2-fill align-bottom me-1"></i> Принять</button>
                                                    </form>

                                                    <form action="{{route('cancel-application-from-side-panel')}}" method="post">
                                                        @csrf @method('PUT')
                                                        <input type="hidden" name="application_id" value="{{$application->id}}">
                                                        <button class="btn btn-dark btn-sm w-100"><i class="ri-xbox-fill align-bottom me-1"></i> Отменить </button>
                                                    </form>
                                                @else
                                                    <button class="btn btn-warning btn-sm w-50"><i class="ri-file-2-fill align-bottom me-1"></i> Изменить</button>
                                                    <form action="{{route('cancel-application-from-side-panel')}}" method="post">
                                                        @csrf @method('PUT')
                                                        <input type="hidden" name="application_id" value="{{$application->id}}">
                                                        <button class="btn btn-dark btn-sm w-100"><i class="ri-xbox-fill align-bottom me-1"></i> Отменить </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </ol>
                            <div class="mt-3 text-center">
                                <a href="{{route('services-applications.index')}}" class="text-muted text-decoration-underline">Смотреть все</a>
                            </div>
                        </div>
                    </div>
                </div> <!-- end card-->
            </div> <!-- end .rightbar-->

        </div> <!-- end col -->
    </div>


@endsection
