@extends('layouts.app')

@section('title')
    Панель Управления U13| Пользователи
@endsection

@section('content')

    @include('parts.messages')
    <div class="user-table mt-5">
    <table id="example" class="display" style="width:100%">
        <thead>
        <tr>
            <th>ID</th>
            <th>ФИО</th>
            <th>Тип</th>
            <th>Email</th>
            <th>Телефон</th>
            <th>Аватар</th>
            <th>Дата Регистрации</th>
            <th>Действия</th>
        </tr>
        </thead>
        <tbody>
        @foreach($users as $user)
            <tr>
                <td>{{$user->id}}</td>
                <td>{{$user->surname}} {{$user->name}} {{$user->middle_name}}</td>
                <td>
                    @if($user->role == 'individual')
                    Физ.лицо
                    @elseif($user->role == 'entity')
                    Юр.лицо
                    @else
                    <b class="text-danger">Администратор</b>
                    @endif
                </td>
                <td>{{$user->email}}</td>
                <td>{{$user->phone}}</td>
                <td>
                    @if($user->avatar != null)
                    <img src="{{$user->avatar}}" style="width: 80px; height: 80px" alt="avatar">
                    @else
                        <img src="{{asset('images/admin/empty.jpg')}}" style="width: 80px; height: 80px" alt="">
                    @endif
                </td>
                <td>{{$user->created_at}}</td>
                <td>
                    <div class="d-block w-100 ">
                        <a><i class='bx bx-edit-alt p-2 user-edit-btn' style="font-size: 22px"></i></a>
                        <form method="post" class="d-inline-block m-2" id="user-delete-{{$user->id}}"
                              action="{{route('user.delete',$user->id)}}">
                            @csrf @method('DELETE')
                            <a href="{{ route('user.delete', $user->id) }}" onclick="event.preventDefault();
                                     document.getElementById('user-delete-{{$user->id}}').submit();">
                                <i class='bx bxs-message-square-x  p-2 user-delete-btn' style="font-size: 22px"></i>
                            </a>
                              <button type="submit" class="d-none"></button>

                        </form>
                    </div>
                </td>
            </tr>
        @endforeach

        </tbody>
        <tfoot>
        <tr>

        </tr>
        </tfoot>
    </table>
    </div>
@endsection

@section('custom-scripts-footer')
    <script>
        $(document).ready(function () {
            $('#example').DataTable({
                "pageLength": 100,
                pagingType: 'full_numbers',
                "language": {
                    "search": "Поиск",
                    paginate: {
                        first:      "Первая",
                        last:       "Последняя",
                        previous: '<<',
                        next:     '>>'
                    },
                    "info":           "Показано _END_ из _TOTAL_ результатов",
                    "infoFiltered":   "(Отфильтровано из _MAX_ total результатов)",
                    "infoPostFix":    "",
                    "lengthMenu":     "Показать _MENU_ результатов",
                }
            });
        });
    </script>
@endsection