@extends('layouts.app')

@section('title')
    Панель Управления U13| Заявки на услуги
@endsection

@section('custom-head-scripts')
    <link rel="stylesheet" href="{{asset('libs/sweetalert2/sweetalert2.min.css')}}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://npmcdn.com/flatpickr/dist/flatpickr.min.js"></script>
    <script src="https://npmcdn.com/flatpickr/dist/l10n/ru.js"></script>

    <style>
        .changed{
            background: rgba(162, 99, 204, 0.69);
            animation: flashing 1s infinite;
        }
        @keyframes  flashing{
            50% {
                opacity: 0.15;
            }
        }
    </style>
@endsection

@section('content')
    @include('parts.messages')

    <div class="row">
        <div class="col-lg-12">
            <div class="card" id="ticketsList">
                <div class="card-header border-0">
                    <div class="d-flex align-items-center">
                        <h5 class="card-title mb-0 flex-grow-1">Заявки</h5>
                        <div class="flex-shrink-0">
                            <div class="d-flex flex-wrap gap-2">
                                <button class="btn btn-danger add-btn" data-bs-toggle="modal" data-bs-target="#showModal"><i class="ri-add-line align-bottom me-1"></i>Создать заявку</button>
                                <button class="btn btn-soft-danger" id="remove-actions" onClick="deleteMultiple()"><i class="ri-delete-bin-2-line"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body border border-dashed border-end-0 border-start-0">
                    <form>
                        <div class="row g-3">
                            <div class="col-xxl-5 col-sm-12">
                                <div class="search-box">
                                    <input type="text" class="form-control search bg-light border-light" placeholder="Поиск заявок ...">
                                    <i class="ri-search-line search-icon"></i>
                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-xxl-3 col-sm-4">
                                <div class="input-light">
                                    <select class="form-control" data-choices data-choices-search-false name="choices-single-default" id="idStatus">
                                        <option value="" disabled>Статус</option>
                                        <option value="all" selected>Все</option>
                                        <option value="Принята">Принята</option>
                                        <option value="Обработка">Обработка</option>
                                        <option value="Выполнена">Выполнена</option>
                                        <option value="Новая">Новая</option>
                                        <option value="Отменена">Отменена</option>
                                        <option value="Изменена">Изменена</option>
                                    </select>
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-xxl-3 col-sm-4 d-none">
                                <input type="text" class="form-control bg-light border-light" data-provider="flatpickr" data-date-format="d M, Y" data-range-date="true" id="demo-datepicker" placeholder="Select date range">
                            </div>

                            <div class="col-xxl-2 col-sm-4">
                                <button type="button" class="btn btn-primary w-100" onclick="SearchData();"> <i class="ri-equalizer-fill me-1 align-bottom"></i>
                                    Применить
                                </button>
                            </div>
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </form>
                </div>
                <!--end card-body-->
                <div class="card-body">
                    <div class="table-responsive table-card mb-4" style="padding-bottom: 100px">
                        <table style="color: #383838" class="table align-middle table-nowrap mb-0" id="ticketTable">
                            <thead>
                            <tr>
                                <th scope="col" style="width: 40px;">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="checkAll" value="option">
                                    </div>
                                </th>
                                <th class="sort" data-sort="id">ID</th>
                                <th class="sort" data-sort="tasks_name">Услуга</th>
                                <th class="sort" data-sort="assignedto">Примечание <i class="bx bx-message-detail"></i></th>
                                <th class="sort" data-sort="client_name">Клиент <i class="bx bx-user-circle"></i></th>
                                <th class="sort" data-sort="tasks_notify">Объект</th>
                                <th class="sort" data-sort="create_date">Дата создания</th>
                                <th class="sort" data-sort="due_date">Выполнить</th>
                                <th class="sort" data-sort="status">Статус <i class="bx bx-notification"></i></th>
                                <th class="sort" data-sort="priority">Приоритет</th>
                                <th class="sort" data-sort="action">Дeйствия</th>
                            </tr>
                            </thead>
                            <tbody class="list form-check-all" id="ticket-list-data">

                            @foreach($applications as $application)
                                @if($application->status == 'Выполнена')
                                    <tr style="background: rgba(10,179,156,0.2); border-bottom: 4px solid #f3f3f3;">
                                @elseif($application->status == 'Отменена')
                                    <tr style="background: rgba(230,62,76,0.3); border-bottom: 4px solid #f3f3f3;">
                                @elseif($application->status == 'Обработка')
                                    <tr style="background: rgba(241,196,99,0.3);border-bottom: 4px solid #f3f3f3;">
                                @elseif($application->status == 'Принята')
                                    <tr style="background: rgba(86,166,215,0.3);border-bottom: 4px solid #f3f3f3;">
                                @else
                                    <tr style="border-bottom: 4px solid #f3f3f3!important">
                                @endif


                                        <th scope="row">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="checkAll" value="option1">
                                            </div>
                                        </th>
                                        <td class="id" style="border-right: 4px solid #f3f3f3"><a href="javascript:void(0);" onclick="ViewTickets(this)" data-id="{{$application->id}}" class="fw-medium link-primary">#UL{{$application->id}}</a></td>
                                        <td class="tasks_name table-secondary fs-11 text-center" style="max-width: 100px; overflow: hidden; white-space: normal; font-weight: bold;border-right: 4px solid #f3f3f3; color: #383838">{{$application->applicationCategory->name}}</td>
                                        <td class="assignedto fs-11" style="max-width: 400px; overflow: hidden; white-space: normal; border-right: 4px solid #f3f3f3">{{$application->message}}</td>
                                        <td class="client_name text-left table-info fs-11" style="max-width: 120px; color: #383838 ;overflow: hidden; white-space: normal; border-right: 4px solid #f3f3f3; font-weight: bold;">{{$application->user->surname}} {{$application->user->name}} {{$application->user->middle_name}}</td>
                                        <td class="tasks_notify fs-11 text-center" style="border-right: 4px solid #f3f3f3; font-weight: bold">{{$application->property->description}}<br> №{{$application->property->name}}</td>
                                        <td class="create_date fs-11" style="border-right: 4px solid #f3f3f3">{{$application->created_at}}</td>
                                        @php
                                            $explodedDueDate = explode(' ', $application->due_date)
                                        @endphp
                                        <td class="due_date table-primary text-left fs-11" style="font-weight: bold;border-right: 4px solid #f3f3f3;">
                                        <span style="border-bottom: 1px dotted">
                                            <i class="bx bx-calendar"></i>
                                            {{$explodedDueDate[0]}}
                                        </span> <br>
                                            <i class="bx bx-time"></i>
                                            {{$explodedDueDate[1]}}
                                        </td>

                                        <td class="status table-info" style="border-right: 4px solid #f3f3f3">@if($application->status == 'Отменена')<span class="badge badge-soft-warning bg-danger text-uppercase text-white">{{$application->status}}</span>
                                            @elseif($application->status == 'Новая')<span class="badge badge-soft-warning bg-dark text-uppercase text-white">{{$application->status}}</span>
                                            @elseif($application->status == 'Обработка')<span class="badge badge-soft-warning bg-warning text-uppercase text-white">{{$application->status}}</span>
                                            @elseif($application->status == 'Принята')<span class="badge badge-soft-warning bg-secondary text-uppercase text-white">{{$application->status}}</span>
                                            @elseif($application->status == 'Выполнена')<span class="badge badge-soft-warning bg-success text-uppercase text-white">{{$application->status}}</span>
                                            @elseif($application->status == 'Изменена')<span class="badge badge-soft-warning text-uppercase text-white changed">{{$application->status}}</span>
                                            @endif
                                        </td>

                                        <td class="priority" style="border-right: 4px solid #f3f3f3">
                                            @if($application->priority == 'Высокий')
                                                <span class="badge bg-danger text-uppercase">
                                            {{$application->priority}}
                                            </span>
                                            @elseif($application->priority == 'Средний')
                                                <span class="badge bg-info text-uppercase">
                                            {{$application->priority}}
                                            </span>
                                            @else
                                                <span class="badge bg-success text-uppercase">
                                            {{$application->priority}}
                                            </span>
                                            @endif

                                        </td>
                                        <td class="text-center">
                                            <div class="dropdown">
                                                <button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <i class="ri-more-fill align-middle"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li><button class="dropdown-item" onclick="location.href = 'apps-tickets-details.html';"><i class="ri-eye-fill align-bottom me-2 text-muted"></i> Просмотр</button></li>
                                                    <li><a class="dropdown-item edit-item-btn" href="#showEditModal-{{$application->id}}" data-bs-toggle="modal"><i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Редактировать</a></li>
                                                    <li>
                                                        <a class="dropdown-item remove-item-btn" data-bs-toggle="modal" href="#deleteOrder-{{$application->id}}">
                                                            <i class="ri-delete-bin-fill align-bottom me-2 text-muted"></i> Удалить
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>

                                    <div class="modal fade flip" id="deleteOrder-{{$application->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-body p-5 text-center">
                                                    <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#405189,secondary:#f06548" style="width:90px;height:90px"></lord-icon>
                                                    <div class="mt-4 text-center">
                                                        <h4>Вы уверены, что хотите удалить заявку ?</h4>
                                                        <p class="text-muted fs-14 mb-4">Данный процесс необратим. Данные будут удалены из базы данных без возможности их восстановления</p>
                                                        <div class="hstack gap-2 justify-content-center remove">
                                                            <button class="btn btn-link link-success fw-medium text-decoration-none" id="deleteRecord-close" data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i> Закрыть</button>
                                                            <form method="post" action="{{route('services-applications.delete', $application->id)}}">
                                                                @csrf @method('DELETE')
                                                                <button class="btn btn-danger" id="delete-record">Да, удалить</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal fade zoomIn" id="showEditModal-{{$application->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-lg">
                                            <div class="modal-content border-0">
                                                <div class="modal-header p-3 bg-soft-info">
                                                    <h5 class="modal-title" id="exampleModalLabel"></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
                                                </div>
                                                <form class="tablelist-form" action="{{route('services-applications.update', $application->id)}}" method="post" autocomplete="off">
                                                    @csrf @method('PUT')
                                                    <div class="modal-body">
                                                        <div class="row g-3">
                                                            <div class="col-lg-12">
                                                                <div id="modal-id">
                                                                    <label for="orderId" class="form-label">ID</label>
                                                                    <input type="text" id="orderId" class="form-control" placeholder="ID" value="#VLZ462" disabled readonly />
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-12">
                                                                <div>
                                                                    <label for="tasksTitle-field2" class="form-label">Услуга</label>
                                                                    <select name="category_id" id="tasksTitle-field2" class="form-control">
                                                                        <option value="" disabled>--Выбрать услугу--</option>
                                                                        @foreach(\App\Models\ApplicationCategory::all() as $category)
                                                                            @if($category->id === $application->application_category_id)
                                                                                <option selected value="{{$category->id}}">{{$category->name}}</option>
                                                                            @else
                                                                                <option value="{{$category->id}}" >{{$category->name}}</option>
                                                                            @endif
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-12">
                                                                <div>
                                                                    <label for="tasks_notify-field" class="form-label">Примечание</label>
                                                                    <textarea type="text" name="message" id="tasks_notify-field" class="form-control" placeholder="Примечание" required> {{$application->message}} </textarea>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <div>
                                                                    <label for="client_nameName-field" class="form-label">Клиент</label>
                                                                    <input readonly disabled type="text" name="user" id="client_nameName-field" value="{{$application->user->surname}} {{$application->user->name}} {{$application->user->middle_name}}" class="form-control" placeholder="ФИО Клиента" required />
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <div>
                                                                    <label for="assignedtoName-field" class="form-label">Адресовано</label>
                                                                    <input type="text" id="assignedtoName-field" class="form-control" placeholder="UL13-service" disabled required />
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-12">
                                                                <label for="date-field" class="form-label">Выполнить</label>
                                                                <input type="text" id="date-field" value="{{$application->due_date}}" name="due_date" class="form-control" data-provider="flatpickr" data-date-format="d M, Y" placeholder="24-12-2023" required />
                                                            </div>

                                                            <div class="col-lg-6">
                                                                <label for="ticket-status2" class="form-label">Статус</label>
                                                                <select class="form-control" data-plugin="choices" name="status" id="ticket-status2">
                                                                    <option disabled value="">Статус</option>


                                                                    @foreach($statuses as $status)
                                                                        @if($application->status === $status)
                                                                            <option selected value="{{$status}}">{{$status}}</option>
                                                                        @else
                                                                            <option  value="{{$status}}">{{$status}}</option>
                                                                        @endif
                                                                    @endforeach

                                                                </select>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <label for="priority-field" class="form-label">Приоритет</label>
                                                                <select class="form-control" data-plugin="choices" name="priority" id="priority-field">
                                                                    <option disabled value="">--Установить приоритет--</option>
                                                                    @foreach($priorities as $priority)
                                                                        @if($application->priority === $priority)
                                                                            <option selected value="{{$priority}}">{{$priority}}</option>
                                                                        @else
                                                                            <option value="{{$priority}}">{{$priority}}</option>
                                                                        @endif
                                                                    @endforeach

                                                                </select>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <div class="hstack gap-2 justify-content-end">
                                                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Закрыть</button>
                                                            <button type="submit" class="btn btn-success" id="add-btn">Добавить</button>
                                                            <!-- <button type="button" class="btn btn-success" id="edit-btn">Update</button> -->
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach

                            </tbody>
                        </table>

                        <div class="noresult" style="display: none">
                            <div class="text-center">
                                <lord-icon src="https://cdn.lordicon.com/msoeawqm.json" trigger="loop" colors="primary:#121331,secondary:#08a88a" style="width:75px;height:75px"></lord-icon>
                                <h5 class="mt-2">Как жаль!</h5>
                                <p class="text-muted mb-0"> Мы обыскали все заявки, но не нашли ничего похожего :(</p>
                            </div>
                        </div>

                    </div>
                    {{--                    <div class="d-flex justify-content-end mt-2">--}}
                    {{--                        <div class="pagination-wrap hstack gap-2">--}}
                    {{--                            <a class="page-item pagination-prev disabled" href="#">--}}
                    {{--                                Назад--}}
                    {{--                            </a>--}}
                    {{--                            <ul class="pagination listjs-pagination mb-0"></ul>--}}
                    {{--                            <a class="page-item pagination-next" href="#">--}}
                    {{--                                Далее--}}
                    {{--                            </a>--}}
                    {{--                        </div>--}}
                    {{--                    </div>--}}
                    {{ $applications->onEachSide(5)->links() }}

                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts-footer')
    <script src="{{asset('libs/list.js/list.min.js')}}"></script>
    <script src="{{asset('libs/list.pagination.js/list.pagination.min.js')}}"></script>
    <script src="{{asset('libs/sweetalert2/sweetalert2.min.js')}}"></script>
    <script src="{{asset('js/admin/ticketlist.init.js')}}"></script>

    <script>
        flatpickr('#date-field', {
            enableTime: true,
            dateFormat: "d-m-Y H:i",
            time_24hr: true,
            minDate: new Date(),
            "locale": "ru"
        })
    </script>
@endsection