@extends('layouts.app')

@section('title')
    Панель Управления U13| Объект {{$property->description}} {{$property->name}} управление
@endsection

@section('custom-head-scripts')

@endsection

@section('content')
    @include('parts.messages')

    <style>
        li.select2-selection__choice {
            padding-left: 36px!important;
        }

    </style>

    <div class="row">
        <div class="col-xl-7">
            <div class="card card-height-100">
                <div class="card-header d-flex align-items-center">
                    <h4 class="card-title flex-grow-1 mb-0">Активные пользователи объекта <b class="text-muted">{{$property->description}} №{{$property->name}}</b>:</h4>
                </div><!-- end cardheader -->
                <div class="card-body">
                    <div class="table-responsive table-card">
                        <table class="table table-nowrap table-centered align-middle">
                            <thead class="bg-light text-muted">
                            <tr>
                                <th scope="col">ФИО</th>
                                <th scope="col">Телефон</th>
                                <th scope="col">Email</th>
                                <th scope="col">Статус</th>
                                <th scope="col">Доп.статус</th>
                                <th scope="col" style="width: 10%;">Действия</th>
                            </tr><!-- end tr -->
                            </thead><!-- thead -->

                            <tbody>
                            @foreach($property->propertyStatuses as $propertyStatus)

                                @if($propertyStatus->approved)
                                    <tr>
                                        <td class="fw-medium">{{$propertyStatus->user->surname}} {{$propertyStatus->user->name}} {{$propertyStatus->user->middle_name}}</td>
                                        <td>
                                            {{$propertyStatus->user->phone}}
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                {{$propertyStatus->user->email}}
                                            </div>
                                        </td>

                                        <td>
                                                @if($propertyStatus->status->name == 'Владелец')
                                                    <span class="badge badge-soft-danger">{{$propertyStatus->status->name}}</span>
                                                @else
                                                    <span class="badge badge-soft-success">{{$propertyStatus->status->name}}</span>
                                                @endif

                                        </td>
                                        <td>
                                            @if(count($property->propertyAdditionalStatusesUser($propertyStatus->user->id)))

                                                @foreach($property->propertyAdditionalStatusesUser($propertyStatus->user->id) as $propertyAdditionalStatus)
                                                    @if($propertyAdditionalStatus->additionalStatus->name == 'Продается')
                                                        <span class="badge badge-soft-danger">{{$propertyAdditionalStatus->additionalStatus->name}}</span>
                                                    @else
                                                        <span class="badge badge-soft-primary">{{$propertyAdditionalStatus->additionalStatus->name}}</span>
                                                    @endif
                                                @endforeach

                                            @else
                                                <span class="badge badge-soft-info">Отсутствует</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex gap-2">
                                                <div class="edit">
                                                    <button class="btn btn-sm btn-success edit-item-btn" data-bs-toggle="modal" data-bs-target="#showModal-{{$propertyStatus->user->id}}"><i class="bx bx-pencil"></i></button>
                                                </div>
                                                <div class="remove">
                                                    <button class="btn btn-sm btn-danger remove-item-btn" data-bs-toggle="modal" data-bs-target="#deleteRecordModal-{{$propertyStatus->user->id}}"> <i class="bx bx-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <!-- end tr -->
                                <!-- Modal -->
                                    <div class="modal fade zoomIn" id="deleteRecordModal-{{$propertyStatus->user->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mt-2 text-center">
                                                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                                                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                                            <h4>Вы уверены?</h4>
                                                            <p class="text-muted mx-4 mb-0">Данное действие необратимо. Вы удалите объект связанный с пользователем и все его статусы относительно данного объекта </p>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">Закрыть</button>
                                                        <form method="post" action="{{route('delete-user-statuses-from-property', [$propertyStatus->user->id, $property->id])}}">
                                                            @csrf @method('DELETE')
                                                            <button type="submit" class="btn w-sm btn-danger " id="delete-record-{{$propertyStatus->user->id}}">Да, удалить!</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach

                            </tbody><!-- end tbody -->
                        </table><!-- end table -->
                    </div>
                </div><!-- end card body -->
            </div><!-- end card -->
        </div><!-- end col -->

        <div class="col-xl-5">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <i class="bx bxs-bell-plus text-danger bx-tada bx-md"></i> <h4 class="card-title mb-0 flex-grow-1 py-1">Заявки на объект</h4>

                </div><!-- end card header -->
                <div class="card-body">
                    <div class="table-responsive table-card">

                        <table class="table table-borderless table-nowrap table-centered align-middle mb-0">
                            <thead class="table-light text-muted">
                            <tr>
                                <th scope="col">ФИО</th>
                                <th scope="col">Телефон</th>
                                <th scope="col">Выбран статус</th>
                                <th scope="col">Действия</th>
                            </tr>
                            </thead><!-- end thead -->
                            @if(count($property->propertyRequests()))
                                <tbody>

                                @foreach($property->propertyRequests() as $requests)
                                    <tr>
                                        <td>
                                            {{$requests->user->surname}}  {{$requests->user->name}} {{$requests->user->middle_name}}
                                        </td>
                                        <td class="text-muted">
                                            {{$requests->user->phone}}
                                        </td>
                                        <td>
                                            @if($requests->status->name === 'Владелец')
                                                <span class="badge badge-soft-danger">{{$requests->status->name}}</span>
                                            @else
                                                <span class="badge badge-soft-success">{{$requests->status->name}}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex gap-2">
                                                <div class="edit">
                                                    <button class="btn btn-sm btn-success edit-item-btn"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#showReqApplyModal-{{$requests->id}}">
                                                        <i class="bx bx-check"
                                                           data-bs-toggle="popover"
                                                           data-bs-placement="top"
                                                           data-bs-trigger="hover focus"
                                                           data-bs-content="Подтвердить заявку"
                                                        ></i>
                                                    </button>
                                                </div>
                                                <div class="remove">
                                                    <button class="btn btn-sm btn-danger remove-item-btn"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#showReqCancelModal-{{$requests->id}}">
                                                        <i class="bx bxs-dislike"
                                                           data-bs-toggle="popover"
                                                           data-bs-placement="top"
                                                           data-bs-trigger="hover focus"
                                                           data-bs-content="Отменить заявку"
                                                        ></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Modal -->
                                    <div class="modal fade zoomIn" id="showReqApplyModal-{{$requests->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mt-2 text-center">
                                                        <lord-icon src="https://cdn.lordicon.com/ivayzoru.json" trigger="loop" colors="outline:#e4e4e4,primary:#16c72e,secondary:#ffffff" stroke="100" style="width:250px;height:250px"></lord-icon>
                                                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                                            <h4> Добавление нового пользователя </h4>
                                                            <p class="text-muted mx-4 mb-0"> Вы одобряете заявку пользователя <b>{{$requests->user->surname}} {{$requests->user->name}}</b>на получение статуса <b>{{$requests->status->name}}</b> для объекта <b>{{$property->description}} {{$property->name}} ? </b> </p>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">Закрыть</button>
                                                        <form method="post" action="{{route('property-status-accept', $requests->id)}}">
                                                            @csrf @method('PUT')
                                                            <button type="submit" class="btn w-sm btn-danger " id="add-user-property-{{$requests->id}}">Да, подтвердить!</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Modal -->
                                    <div class="modal fade zoomIn" id="showReqCancelModal-{{$requests->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mt-2 text-center">
                                                        <lord-icon src="https://cdn.lordicon.com/vsgcujbd.json" trigger="loop" colors="primary:#f24c00,secondary:#121331,tertiary:#ebe6ef" style="width:250px;height:250px"></lord-icon>
                                                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                                            <h4> Отклонение запроса </h4>
                                                            <p class="text-muted mx-4 mb-0"> Вы отклоняете запрос пользователя <b>{{$requests->user->surname}} {{$requests->user->name}}</b>на получение статуса <b>{{$requests->status->name}}</b> для объекта <b>{{$property->description}} {{$property->name}} ? </b> </p>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">Закрыть</button>
                                                        <form method="post" action="#">
                                                            @csrf @method('DELETE')
                                                            <button type="submit" class="btn w-sm btn-danger " id="cancel-user-property-{{$requests->id}}">Да, отклонить!</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                                <!-- end -->
                                </tbody><!-- end tbody -->
                            @else
                                <h3 class="text-muted text-center p-2">Входящие запросы отсутствуют</h3>
                            @endif
                        </table><!-- end table -->
                    </div>
                </div><!-- end cardbody -->
            </div><!-- end card -->
        </div><!-- end col -->
    </div><!-- end row -->

    <div class="row mb-5">
        <div class="col-xxl-4 px-1">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <i class="bx bx-user-plus bx-md"></i> <h4 class="card-title mb-0 flex-grow-1">Добавить нового пользователя:</h4>
                </div><!-- end card header -->

                <div class="card-body" style="padding:10px 12px">
                    <form class="some-form" autocomplete="off" method="post" action="{{route('property.add-new-user')}}">
                        @csrf
                        <div class="col-lg-12">
                        <h6 class="fw-semibold">Получатель *</h6>
                        <label for="select222" class="form-label">Выбор жильца</label>
                        <div class="input-group">
                            <div class="input-group-text"><i class='bx bx-user'></i></div>
                            <select name="user_id" class="js-example-basic-multiple form-control" id="select222" required>
                                <option value="" disabled selected>--Выбрать жильца--</option>
                                @php
                                    $users = \App\Models\User::all();
                                @endphp
                                @foreach($users as $user)

                                   <option value="{{$user->id}}">{{$user->surname}} {{$user->name}} {{$user->middle_name}}</option>

                                @endforeach
                            </select>
                        </div>
                    </div>

                        <input type="hidden" name="property_id" value="{{$property->id}}">

                        <div class="col-lg-12 mt-4">
                            <h6 class="fw-semibold">Основной статус *</h6>
                            <div>
                                <div class=" row">
                                    @php
                                        $main_statuses = \App\Models\Status::all();
                                    @endphp
                                    @foreach($main_statuses as $status)
                                        <div class="col-auto">
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="radio" name="main_status_id" value="{{$status->id}}" id="flexRadioDefault{{$status->id}}" required>
                                                <label class="form-check-label" for="flexRadioDefault{{$status->id}}">
                                                   {{$status->name}}
                                                </label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>


                            </div>
                        </div>

                        <div class="col-lg-12 mt-4">
                            <h6 class="fw-semibold">Дополнительный статус *</h6>
                            <div>
                                <div class=" row">
                                    @php
                                        $additional_statuses = \App\Models\AdditionalStatus::all();
                                    @endphp
                                    <select class="js-example-basic-multiple" name="additional_statuses[]" multiple="multiple">
                                        @foreach($additional_statuses as $status)
                                            <option value="{{$status->id}}">{{$status->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-success"><i class="bx bx-add-to-queue"></i>Добавить</button>
                        </div>
                    </form>
                </div><!-- end cardbody -->
            </div><!-- end card -->
        </div><!-- end col -->

        <div class="col-xxl-4 col-lg-6">
            <div class="card card-height-100">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Запросы на аренду</h4>
                </div><!-- end card header -->

                <div class="card-body p-0">

                </div><!-- end cardbody -->
            </div><!-- end card -->
        </div><!-- end col -->

        <div class="col-xxl-4 col-lg-6">
            <div class="card card-height-100">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Запросы на покупку</h4>
                </div><!-- end card header -->

                <div class="card-body">

                </div><!-- end cardbody -->
            </div><!-- end card -->
        </div><!-- end col -->
    </div><!-- end row -->
@endsection


@section('custom-scripts-footer')

    <script src="{{asset('libs/select2/js/select2.full.min.js')}}"></script>
    <script src="{{asset('js/admin/select2.init.js')}}"></script>

@endsection