@extends('layouts.app')

@section('title')
    Панель Управления U13| Управление объектами
@endsection

@section('custom-head-scripts')

@endsection

@section('content')
    @include('parts.messages')

        <div class="row">
        @foreach($properties as $property)
            <div class="col-xxl-auto col-lg-4 col-md-4 col-sm-4">
            <div class="tasks-list" style="min-width: 300px">
                <div data-simplebar="init" class=" px-3 mx-n3">
                    <div class="simplebar-wrapper" style="margin: 0px -16px;">
                        <div class="simplebar-mask">
                            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                                <div class="simplebar-content-wrapper" tabindex="0" role="region"
                                     aria-label="scrollable content" style="height: auto; overflow: hidden scroll;">
                                    <div class="simplebar-content" style="padding: 0px 16px;">
                                        <div id="reviews-task" class="tasks">
                                            <div class="card tasks-box">
                                                <div class="card-body">
                                                    <div class="d-flex mb-2">
                                                        <a href="javascript:void(0)"
                                                           class="text-muted fw-medium fs-16 flex-grow-1"> {{$property->description}} {{$property->name}}</a>
                                                        <div class="dropdown">
                                                            <a href="javascript:void(0);" class="text-muted"
                                                               id="dropdownMenuLink7" data-bs-toggle="dropdown"
                                                               aria-expanded="false"><i class="ri-more-fill"></i></a>
                                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink7"
                                                                style="">
                                                                <li><a class="dropdown-item" href="apps-tasks-details.html"><i
                                                                                class="ri-eye-fill align-bottom me-2 text-muted"></i>
                                                                        View</a></li>
                                                                <li><a class="dropdown-item" href="#"><i
                                                                                class="ri-edit-2-line align-bottom me-2 text-muted"></i>
                                                                        Edit</a></li>
                                                                <li><a class="dropdown-item" data-bs-toggle="modal"
                                                                       href="#deleteRecordModal"><i
                                                                                class="ri-delete-bin-5-line align-bottom me-2 text-muted"></i>
                                                                        Delete</a></li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <h6 class="fs-15 text-truncate task-title">
                                                        <a href="apps-tasks-details.html" class="d-block">


                                                        </a>
                                                    </h6>
                                                    <div class="tasks-img rounded" style="height: 280px">
                                                        <a href="{{route('property.show', $property->id)}}">
                                                            <img src="{{$property->main_img}}" style="width: 100%; margin-bottom: 20px" alt="">
                                                        </a>
                                                    </div>
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1">
                                                            @foreach($property->propertyStatuses as $propertyStatus)
                                                                @if($propertyStatus->status->name === 'Владелец')
                                                                    <span class="badge badge-soft-danger"
                                                                          data-bs-toggle="popover"
                                                                          data-bs-placement="top"
                                                                          data-bs-trigger="hover focus"
                                                                          data-bs-content="{{$propertyStatus->user->surname}} {{$propertyStatus->user->name}} {{$propertyStatus->user->middle_name}}"
                                                                    >
                                                                        {{$propertyStatus->status->name}}
                                                                    </span>
                                                                @else
                                                                    <span class="badge badge-soft-info"
                                                                          data-bs-toggle="popover"
                                                                          data-bs-placement="top"
                                                                          data-bs-trigger="hover focus"
                                                                          data-bs-content="{{$propertyStatus->user->surname}} {{$propertyStatus->user->name}} {{$propertyStatus->user->middle_name}}"
                                                                    >
                                                                        {{$propertyStatus->status->name}}
                                                                    </span>
                                                                @endif
                                                            @endforeach
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="card-footer border-top-dashed position-relative">
                                                    <div class="d-flex">
                                                        <div class="flex-grow-1">
                                                            <span class="text-muted">Сведения:</span>
                                                        </div>
                                                        <div class="flex-shrink-0 d-flex align-items-end position-absolute" style="top:-5px; right: 10px; min-height: 40px">
                                                            <ul class="link-inline mb-0">
                                                                <li class="list-inline-item">
                                                                    <a href="javascript:void(0)"
                                                                       data-bs-toggle="popover"
                                                                       data-bs-placement="top"
                                                                       data-bs-trigger="hover focus"
                                                                       data-bs-content="Количество пользователей"
                                                                       class="text-muted">
                                                                        <i class="bx bx-user-circle"></i>
                                                                        {{$property->users()->count()}}
                                                                    </a>
                                                                </li>
                                                                <li class="list-inline-item">
                                                                    <a href="javascript:void(0)"
                                                                       data-bs-toggle="popover"
                                                                       data-bs-placement="top"
                                                                       data-bs-trigger="hover focus"
                                                                       data-bs-content="Обращений за услугами"
                                                                       class="text-muted">
                                                                        <i class="bx bxs-notification"></i>
                                                                        {{$property->applications()->count()}}
                                                                    </a>
                                                                </li>
                                                                <li class="list-inline-item">
                                                                    <a href="javascript:void(0)"
                                                                       data-bs-toggle="popover"
                                                                       data-bs-placement="top"
                                                                       data-bs-trigger="hover focus"
                                                                       data-bs-content="Количество заявок на подтверждение аренды/собственности"
                                                                       class="text-muted">
                                                                        @if($property->propertyRequestsCount() > 0)
                                                                            <i class="bx bxs-bell-plus text-danger bx-tada bx-md"></i>
                                                                            <b class="text-danger fs-16">{{$property->propertyRequestsCount()}}</b>
                                                                        @else
                                                                            <i class="bx bx-bell-plus"></i>
                                                                            {{$property->propertyRequestsCount()}}
                                                                        @endif
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end card-body-->
                                                <div class="progress progress-sm">
                                                    <div class="progress-bar bg-success" role="progressbar"
                                                         style="width: 100%" aria-valuenow="55" aria-valuemin="0"
                                                         aria-valuemax="100"></div>
                                                </div>
                                            </div>
                                            <!--end card-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="simplebar-placeholder" style="width: auto; height: 500px;"></div>
                    </div>

                </div>
            </div>
            </div>
        @endforeach
        </div>
        <!--end tasks-list-->

@endsection

@section('custom-scripts-footer')

@endsection