@extends('layouts.app')

@section('title')
    Панель Управления U13| Уведомления
@endsection

@section('custom-head-scripts')

@endsection

@section('content')
    <style>
        span.select2.select2-container.select2-container--default.select2-container--below {
            width: 90%!important;
        }
        span.select2.select2-container.select2-container--default {
            width: 90%!important;
        }
    </style>
    <div class="row">

        <div class="col-lg-12">
            @include('parts.messages')
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Добавить новое уведомление</h4>
                </div><!-- end card header -->

                <div class="card-body">
                    <div class="listjs-table" id="customerList">
                        <div class="row g-4 mb-3">
                            <div class="col-sm-auto">
                                <div>
                                    <a href="{{route('notifications.index')}}"><button class="btn btn-soft-danger" ><i class="ri-arrow-go-back-fill"></i> Назад</button></a>
                                    <button type="button" class="btn btn-success add-btn" data-bs-toggle="modal" id="create-btn" data-bs-target="#showModalAdd"><i class="ri-add-line align-bottom me-1"></i> Создать</button>
                                </div>
                            </div>
                            <div class="col-sm">
                                <div class="d-flex justify-content-sm-end">
                                    <div class="search-box ms-2">
                                        <input type="text" class="form-control search" placeholder="Поиск...">
                                        <i class="ri-search-line search-icon"></i>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive table-card mt-3 mb-1">
                            <table class="table align-middle table-nowrap" id="customerTable">
                                <thead class="table-light">
                                <tr>
                                    <th scope="col" style="width: 50px;">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="checkAll" value="option">
                                        </div>
                                    </th>
                                    <th class="sort" data-sort="customer_name">Получалень</th>
                                    <th class="sort" data-sort="email">Заголовок</th>
                                    <th class="sort" data-sort="phone">Сообщение</th>
                                    <th class="sort" data-sort="date">Отправлено</th>
                                    <th class="sort" data-sort="status">Статус</th>
                                    <th class="sort" data-sort="action">Действия</th>
                                </tr>
                                </thead>
                                <tbody class="list form-check-all">
                                @foreach($notifications as $notification)
                                    <!-- Modal -->
                                    <div class="modal fade zoomIn" id="deleteRecordModal-{{$notification->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="mt-2 text-center">
                                                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                                                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                                                            <h4>Вы уверены?</h4>
                                                            <p class="text-muted mx-4 mb-0">Данное действие необратимо. Удалить уведомление ?</p>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">Закрыть</button>
                                                        <form method="post" action="{{route('notification.delete', $notification->id)}}">
                                                            @csrf @method('DELETE')
                                                            <button type="submit" class="btn w-sm btn-danger " id="delete-record-{{$notification->id}}">Да, удалить!</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--end modal -->
                                <tr>
                                    <th scope="row">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="chk_child" value="option1">
                                        </div>
                                    </th>
                                    <td class="id" style="display:none;"><a href="javascript:void(0);" class="fw-medium link-primary">#UL{{$notification->id}}</a></td>
                                    <td class="customer_name" style="max-width: 120px; white-space: normal;">{{$notification->user->surname}} {{$notification->user->name}} {{$notification->user->middle_name}}</td>
                                    <td class="email" style="max-width: 150px; white-space: normal;">{{$notification->title}}</td>
                                    <td class="phone" style="max-width: 350px; white-space: normal;">{{$notification->message}}</td>
                                    @php
                                        $sendDateTime = explode(' ', mb_substr($notification->created_at, 0,16));
                                    @endphp
                                    <td class="date"><i class="bx bx-calendar"></i> {{$sendDateTime[0]}} <br> <i class="bx bx-time"></i> {{$sendDateTime[1]}}</td>
                                    <td class="status">
                                        @if($notification->visited == true)
                                            <span class="badge badge-soft-success text-uppercase">Просмотрено</span>
                                        @else
                                            <span class="badge badge-soft-danger text-uppercase">Не просмотрено</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex gap-2">
                                            <div class="edit">
                                                <button class="btn btn-sm btn-success edit-item-btn" data-bs-toggle="modal" data-bs-target="#showModal"><i class="bx bx-pencil"></i></button>
                                            </div>
                                            <div class="remove">
                                                <button class="btn btn-sm btn-danger remove-item-btn" data-bs-toggle="modal" data-bs-target="#deleteRecordModal-{{$notification->id}}"> <i class="bx bx-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                                </tbody>
                            </table>
                            <div class="noresult" style="display: none">
                                <div class="text-center">
                                    <lord-icon src="https://cdn.lordicon.com/msoeawqm.json" trigger="loop" colors="primary:#121331,secondary:#08a88a" style="width:75px;height:75px"></lord-icon>
                                    <h5 class="mt-2">Как жаль:( Но ничего не удалось найти</h5>
                                    <p class="text-muted mb-0">Мы обыскали все исходящие уведомления, но ничего подобного не было найдено</p>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <div class="pagination-wrap hstack gap-2">
                                {{ $notifications->onEachSide(5)->links() }}
                            </div>
                        </div>
                    </div>
                </div><!-- end card -->
            </div>
            <!-- end col -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

    <div class="modal fade" id="showModalAdd"  aria-labelledby="exampleModalLabel" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light p-3">
                    <h5 class="modal-title" id="exampleModalLabel"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal-{{$notification->id}}"></button>
                </div>
                <form class="tablelist-form" autocomplete="off" method="post" action="{{route('notification.store')}}">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3" id="modal-id-{{$notification->id}}" style="display: none;">
                            <label for="id-field" class="form-label">ID</label>
                            <input type="text" id="id-field-{{$notification->id}}" class="form-control" placeholder="ID" readonly />
                        </div>

                        <div class="mb-3">
                            <div class="col-lg-12">
                                <h6 class="fw-semibold">Получатель </h6>
                                <i class='bx bx-user'></i> <span for="exampleDataList" class="form-label">{{$user->surname}} {{$user->name}} {{$user->middle_name}}</span>
                                <div class="input-group">
                                    <input name="user_id" hidden  value="{{$user->id}}">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="email-field" class="form-label">Заголовок</label>
                            <input type="text" name="title" id="email-field" class="form-control" placeholder="Введите заголовок" required />
                            <div class="invalid-feedback"> Это обязательное поле</div>
                        </div>

                        <div class="mb-3">
                            <label for="message-field" class="form-label">Сообщение</label>
                            <textarea id="message-field" name="message" class="form-control" cols="12" required > </textarea>
                            <div class="invalid-feedback">Пожалуйста, введите ваше сообщение</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Закрыть</button>
                            <button type="submit" class="btn btn-success" id="add-btn">Создать</button>
                            <!-- <button type="button" class="btn btn-success" id="edit-btn">Update</button> -->
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="showModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light p-3">
                    <h5 class="modal-title" id="exampleModalLabel"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
                </div>
                <form class="tablelist-form" autocomplete="off">
                    <div class="modal-body">
                        <div class="mb-3" id="modal-id" style="display: none;">
                            <label for="id-field" class="form-label">ID</label>
                            <input type="text" id="id-field" class="form-control" placeholder="ID" readonly />
                        </div>

                        <div class="mb-3">
                            <label for="customername-field" class="form-label">Customer Name</label>
                            <input type="text" id="customername-field" class="form-control" placeholder="Enter Name" required />
                            <div class="invalid-feedback">Please enter a customer name.</div>
                        </div>

                        <div class="mb-3">
                            <label for="email-field" class="form-label">Email</label>
                            <input type="email" id="email-field" class="form-control" placeholder="Enter Email" required />
                            <div class="invalid-feedback">Please enter an email.</div>
                        </div>

                        <div class="mb-3">
                            <label for="phone-field" class="form-label">Phone</label>
                            <input type="text" id="phone-field" class="form-control" placeholder="Enter Phone no." required />
                            <div class="invalid-feedback">Please enter a phone.</div>
                        </div>

                        <div class="mb-3">
                            <label for="date-field" class="form-label">Joining Date</label>
                            <input type="text" id="date-field" class="form-control" placeholder="Select Date" required />
                            <div class="invalid-feedback">Please select a date.</div>
                        </div>

                        <div>
                            <label for="status-field" class="form-label">Status</label>
                            <select class="form-control" data-trigger name="status-field" id="status-field" required>
                                <option value="">Status</option>
                                <option value="Active">Active</option>
                                <option value="Block">Block</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="hstack gap-2 justify-content-end">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Закрыть</button>
                            <button type="submit" class="btn btn-success" id="add-btn">Добавить уведомление</button>
                            <!-- <button type="button" class="btn btn-success" id="edit-btn">Update</button> -->
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <!-- Modal -->
    <div class="modal fade zoomIn" id="deleteRecordModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="btn-close"></button>
                </div>
                <div class="modal-body">
                    <div class="mt-2 text-center">
                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                        <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                            <h4>Вы уверены?</h4>
                            <p class="text-muted mx-4 mb-0">Данное действие необратимо. Удалить уведомление ?</p>
                        </div>
                    </div>
                    <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                        <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">Закрыть</button>
                        <button type="button" class="btn w-sm btn-danger " id="delete-record">Да, удалить!</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end modal -->
@endsection


@section('custom-scripts-footer')
    <script src="{{asset('libs/prismjs/prism.js')}}"></script>
    <script src="{{asset('libs/list.js/list.min.js')}}"></script>
    <script src="{{asset('libs/list.pagination.js/list.pagination.min.js')}}"></script>
    <script src="{{asset('js/admin/listjs.init.js')}}"></script>
    <script src="{{asset('libs/select2/js/select2.full.min.js')}}"></script>

    <script>


        $('#select22').select2({
            dropdownParent: $('.input-group')
        });
    </script>


@endsection
