@extends('layouts.app')

@section('title')
    Панель Управления U13| Cчета
@endsection

@section('custom-head-scripts')
    <link rel="stylesheet" href="{{asset('libs/lightbox/css/lightbox.min.css')}}">
@endsection

@section('content')

    <div class="row">
    @foreach($users as $user)

            <div class="col-xl-3 col-md-6">
                <!-- card -->
                <div class="card card-animate">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1 overflow-hidden">
                                @if($user->role != 'admin')
                                <p class="text-uppercase fw-medium fw-bold text-muted text-truncate mb-0">{{$user->surname}} {{$user->name}}</p>
                                @else
                                <p class="text-uppercase fw-medium fw-bold text-danger text-truncate mb-0">{{$user->surname}} {{$user->name}}</p>
                                @endif

                            </div>

                            @php
                                $invoiceSum = DB::table('invoices')->where('user_id', $user->id)->pluck('amount')->sum();
                            @endphp
                            <div class="flex-shrink-0">

                                @if($invoiceSum >= 0)
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i> +{{$invoiceSum}} ₽
                                    </h5>
                                @else
                                    <h5 class="text-danger fs-14 mb-0">
                                        <i class="ri-arrow-right-down-line fs-13 align-middle"></i> {{$invoiceSum}} ₽
                                    </h5>
                                @endif

                            </div>
                        </div>
                        <div class="d-flex align-items-end justify-content-between mt-4">
                            <div>

                                <h4 class="fs-14 text-warning fw-semibold ff-secondary mb-4">
                                    Cчетов:
                                    <span class="counter-value" data-target="{{$user->invoices->count()}}">0</span>
                                </h4>

                                <a href="#" class="text-decoration-underline"
                                   data-bs-toggle="modal"
                                   data-bs-target="#invoices-{{$user->id}}">
                                    Посмотреть все
                                </a>
                            </div>
                            <div class="avatar-sm flex-shrink-0">
                                 <span class="avatar-title bg-soft-success rounded fs-3">
                                     @php
                                         preg_match('/[^\/]+\.[^.]+$/', $user->avatar, $matches);

                                     @endphp
                                     <a href="{{$user->avatar}}" data-lightbox="{{$matches[0]}}">
                                     <img src="{{$user->avatar}}" width="70" height="70" >
                                     </a>
                                 </span>
                            </div>
                        </div>
                    </div><!-- end card body -->
                </div><!-- end card -->

                <!-- Modal -->
                <div class="modal fade" id="invoices-{{$user->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-scrollable modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">{{$user->name}} {{$user->surname}} | Все счета </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <table class="table table-striped">
                                    <thead>
                                    <tr>
                                        <th scope="col">#ID</th>
                                        <th scope="col">Отправитель</th>
                                        <th scope="col">Категория</th>
                                        <th scope="col">Сообщение</th>
                                        <th scope="col">Период</th>
                                        <th scope="col">Сумма</th>
                                        <th scope="col">Просмотрено</th>
                                    </tr>
                                    </thead>
                                    <tbody >
                                    @foreach($user->invoices as $invoice)

                                    <tr>
                                        <th scope="row">{{$invoice->id}}</th>
                                        <td class="table-info">{{$invoice->sender}}</td>
                                        <td class="table-warning">{{$invoice->category->name}}</td>
                                        <td>{{$invoice->message}}</td>
                                        <td class="table-info">{{$invoice->period}}</td>

                                        @if($invoice->amount < 0)
                                            <td class="text-danger ">
                                                {{$invoice->amount}} руб.
                                        @else
                                            <td class="text-success ">
                                                +{{$invoice->amount}} руб.
                                            @endif
                                        </td>

                                            @if($invoice->visited)
                                            <td class="table-success text-center">
                                               <span class="">Да</span>
                                            @else
                                            <td class="table-danger text-center">
                                                <span class="">Нет</span>
                                            @endif

                                        </td>
                                    </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="modal-footer">

                            </div>
                        </div>
                    </div>
                </div>
                <!--End Modal -->

            </div><!-- end col -->

    @endforeach
        {{ $users->onEachSide(5)->links() }}
    </div>
@endsection

@section('custom-scripts-footer')
    <script src="{{asset('libs/lightbox/js/lightbox.min.js')}}"></script>
@endsection