@extends('layouts.app')

@section('title')
    Панель Управления U13| Создать счет
@endsection

@section('custom-head-scripts')

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://npmcdn.com/flatpickr/dist/flatpickr.min.js"></script>
    <script src="https://npmcdn.com/flatpickr/dist/l10n/ru.js"></script>

    <style>
        .flatpickr-months {
            background: #ffffff!important;
        }
        .list-group-item {
            position: relative;
            display: block;
            padding: .75rem 1.25rem;
            background-color: var(--vz-header-bg);
            border: 1px solid rgba(0,0,0,.125);
        }

        .avatar.avatar-44 {
            line-height: 40px;
            height: 45px;
            width: 45px;
        }
        .avatar {
            position: relative;
            display: inline-block;
            overflow: hidden;
            margin: 0;
            text-align: center;
            vertical-align: middle;
        }
        .coverimg {
            background-size: cover;
            background-position: center center;
        }

    </style>

@endsection

@section('content')

    @include('parts.messages')

    <div class="row mt-5">
        <div class="col-lg-12">
            <div class="card" style="padding: 40px">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Выставить счет пользователю</h4>

                </div><!-- end card header -->

                <div class="card-body" >
                    <p class="text-muted">Заполните <code>поля</code> формы ниже выбрав пользователя (жильца). В полях укажите <code>тип, объем, сумму, единицы измерения и диапазон времени</code> оказанной услуги.
                        Поля помеченые < * > - обязательны для заполнения</p>
                    <div class="live-preview">
                        <form action="{{ route('invoice.store') }}" method="post" id="dynamicForm">
                            @csrf
                            <div class="row gy-2 gx-3 mb-3 mt-5 align-items-center">
                                <div class="col-lg-5">
                                    <h6 class="fw-semibold">Получатель *</h6>
                                    <label class="visually-hidden" for="userSelect2">Выбрать жильца</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class='bx bx-user'></i></div>
                                        <select class="js-example-basic-single form-select" id="userSelect2" name="user_id" required>
                                        <option selected value=""> -- Выбрать пользователя -- </option>
                                            @foreach($users as $user)
                                                @if($user->role == 'admin')
                                                    @continue
                                                @endif
                                                <option value="{{$user->id}}">{{$user->surname}} {{$user->name}} {{$user->middle_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-3">
                                    <h6 class="fw-semibold">Email для оповещения</h6>
                                    <label class="visually-hidden" for="autoSizingInputGroup">Email</label>
                                    <div class="input-group">
                                        <div class="input-group-text">@</div>
                                        <input type="email" class="form-control" name="email" id="autoSizingInputGroup" placeholder="Email пользователя">
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-4">
                                    <h6 class="fw-semibold">Тип счета *</h6>
                                    <label class="visually-hidden" for="autoSizingSelect">Категория</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class='bx bx-category'></i></div>
                                        <select class="form-select" name="category_id" data-dynamic="avatar" data-choices data-choices-sorting="true" id="autoSizingSelect" required>
                                            <option selected value="">Выбрать категорию...</option>
                                            @foreach($categories as $category)
                                                <option value="{{$category->id}}">{{$category->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <!--end col-->

                                <!--end col-->
                            </div>
                            <!--end row-->
                            <div class="row gx-3 gy-2 mt-5 mb-5 align-items-center">

                                <div class="col-lg-3">
                                    <h6 class="fw-semibold">Отправитель *</h6>
                                    <label class="visually-hidden" for="specificSizeInputSender">Sender</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class="bx bx-send"></i></div>
                                        <input type="text" name="sender" class="form-control" value="ul13-service" id="specificSizeInputSender" placeholder="Отправитель" required>
                                    </div>
                                </div>

                                <div class="d-none">
                                    @foreach($categories as $category)
                                        <img src="{{$category->categoryImage}}" id="categoryImage-{{$category->id}}" alt="">
                                    @endforeach
                                </div>

                                <!--end col-->
                                <div class="col-sm-3">
                                    <h6 class="fw-semibold">Использовано: *</h6>
                                    <label class="visually-hidden" for="specificSizeInputGroupValue">Value</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class="bx bx-cube-alt"></i></div>
                                        <input type="number" name="resourceValue" class="form-control" id="specificSizeInputGroupValue" placeholder="" required>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-3">
                                    <h6 class="fw-semibold">Ед. изм.: *</h6>
                                    <label class="visually-hidden" for="specificSizeInputGroupUnits">Units</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class='bx bx-expand-horizontal'></i></div>
                                        <select class="form-select" name="unit" data-choices data-choices-sorting="true" id="specificUnitsSelect" required>
                                            <option selected value="КВт">КВт</option>
                                            <option value="м3">м3</option>
                                            <option value="Согласно тарифу">Согласно тарифу</option>
                                            <option value="none">Другое</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <h6 class="fw-semibold">На сумму: *</h6>
                                    <label class="visually-hidden" for="specificSizeInputGroupSum">Sum</label>
                                    <div class="input-group">
                                        <div class="input-group-text"><i class="bx bx-ruble"></i></div>
                                        <input type="number" data-dynamic="amount" name="amount" class="form-control" id="specificSizeInputGroupSum" placeholder="Введите сумму" required>
                                    </div>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <h5 for="flatpickr-range">Диапазон времени оказания услуг *</h5>
                                        <div class="input-group">
                                            <div class="input-group-text"><i class="bx bx-calendar"></i></div>
                                            <input class="form-control flatpickr" name="period" type="text" placeholder="Выбрать диапазон" id="flatpickr-range" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <h5 for="flatpickr-range">Текст сообщения *</h5>
                                        <div class="input-group">
                                            <div class="input-group-text"><i class="bx bx-message"></i></div>
                                           <textarea class="form-control" required name="message" data-dynamic="message" style="min-height: 100px">Оплата счетов за поставку </textarea>
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-4">
                                    <hr>
                                </div>

                                <div class="col-lg-6">
                                    <div class="row">

                                        <div class="col-6">
                                            <h4> Push уведомление</h4>
                                        </div>

                                        <div class="col-6">
                                            <div class="form-check form-switch form-switch-lg" dir="ltr">
                                                <input type="checkbox" value="1" name="push-checkbox" class="form-check-input" id="customSwitchsizelg" checked="">
                                                <label class="form-check-label" for="customSwitchsizelg">Отправить Push уведомление</label>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row">

                                        <div class="col-6 align-self-center">
                                            <h6 class="fw-semibold">Заголовок</h6>
                                            <label class="visually-hidden" for="specificSizeInputGroupSum">Push-title</label>
                                            <div class="input-group">
                                                <div class="input-group-text"><i class="bx bx-heading"></i></div>
                                                <input type="text" value="Ваши счета были обновлены!" data-dynamic="push-title" name="push-title" class="form-control" id="specificSizeInputGroupPushTitle" placeholder="Заголовок Push уведомления">
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <h5 >Push сообщение</h5>
                                                <div class="input-group">
                                                    <div class="input-group-text"><i class="bx bx-message"></i></div>
                                                    <textarea class="form-control" name="push-message" data-dynamic="push-message" style="min-height: 80px"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-6 text-left align-self-center">
                                    <h6 class="fw-semibold"> &nbsp</h6>
                                    <button type="submit" class="btn btn-primary p-4 fs-14" style="margin-left: 40px">Отправить ...</button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!--end row-->

    <div class="row  mb-5">
        <div class="col-lg-6 d-flex align-self-center py-2" style="padding: 20px 40px"> <h5 class="text-muted"> Превью отправляемого счета: </h5> </div>
        <div class="col-lg-6 d-flex align-self-center py-2">

            <a class="list-group-item bg-white mb-2 d-block w-100">
                <div class="row">
                    <div class="col-auto pr-0 pl-1">
                        <div class="avatar avatar-44 coverimg rounded-10" id="avatar" style="background-image: url({{asset('images/admin/categories/energy.png')}})">
                            <img src="" alt="" style="display: block;">
                        </div>
                    </div>
                    <div class="col align-self-center ps-0">
                        <p class="mb-1">от <b style="text-decoration: underline">ul13-service</b> | <span id="message"> Оплата счетов за поставку эл. энергии </span></p>
                        <p class="size-12 float-end" id="amount"> 0 <span>₽</span></p>
                        <p class="size-12 text-muted">{{date('d.m.Y')}}</p>
                    </div>
                </div>
            </a>

        </div>
    </div>

    <div class="row">
        <div class="col-6 d-flex align-self-center py-2" style="padding: 20px 40px">  <h5 class="text-muted "> Превью Push уведомления </h5></div>
        <div class="col-4 text-center">
            <phone-preview  class="android-preview">
                <div  class="android preview-background" style="background-image: url({{asset('/images/admin/android.png')}}); background-repeat: no-repeat; padding: 15% 4.6632124352% 0;display: flex;background-size: 100%;margin: 4px; max-width: 350px ">
                    <mat-card  class="mat-card mat-focus-indicator banner-card" style="padding: 8px;margin: 4px;border-radius: 0px;width: 100%; background-color: #fff"><!---->
                        <div  class="banner-content" style="display: flex; justify-content: space-between">
                            <div  class="banner-text">
                                <div  class="title" id="push-title">Заголовок Push уведомления</div>
                                <div  class="text" id="push-message">Ваше сообщение будет здесь</div>
                            </div>
                            <img class="banner-image ng-star-inserted" src="{{asset('/images/admin/image_placeholder.png')}}" style="height: 40px; margin-left: 8px;">
                        </div>
                    </mat-card>
                </div>
                <h5 class="phone-label" style="max-width: 350px" >Android</h5>
            </phone-preview>
        </div>
    </div>

@endsection

@section('custom-scripts-footer')
    <script>

        flatpickr('#flatpickr-range', {
            mode: "range",
            dateFormat: "m.d.Y",
            minDate: "01.2022",
            "locale": "ru"

        })

        const form = document.getElementById('dynamicForm');

        form.addEventListener('change', function (e) {

            let fieldToSwitch = document.getElementById(e.target.dataset.dynamic);

            switch (e.target.dataset.dynamic) {

                case 'avatar':
                    let categoryIdSelected = e.target.options[e.target.selectedIndex].value
                    fieldToSwitch.style.backgroundImage =
                        `url(${document.getElementById('categoryImage-' + categoryIdSelected).src})`;
                    break

                case 'message':

                    let switchedText = e.target.value
                    fieldToSwitch.innerText = switchedText.length < 50 ?
                        switchedText: switchedText.substring(0,50) + '...';
                    break

                case 'amount':
                    let switchedAmount = e.target.value;
                    fieldToSwitch.innerText = switchedAmount + ' ₽';
                    switchedAmount >= 0 ? fieldToSwitch.classList.add('text-success') :
                        fieldToSwitch.classList.add('text-danger');
                    break
                case 'push-title':
                    let switchedPushTitle = e.target.value;
                    fieldToSwitch.innerText = switchedPushTitle;
                    break

                case 'push-message':
                    let switchedPushMessage = e.target.value;
                    fieldToSwitch.innerText = switchedPushMessage;
                    break


            }

        });


    </script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script src="{{asset('js/admin/select2.init.js')}}"></script>
@endsection