<?php

namespace Database\Seeders;

use App\Models\Status;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class StatusesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    private array $statuses = [
        ['Арендован', 'rented'], ['Владелец', 'owner'],
    ];

    public function run(): void
    {
        foreach ($this->statuses as $status) {
            Status::create([
                'name' => $status[0],
                'slug' => $status[1],
            ]);
        }

    }
}
