<?php

namespace Database\Seeders;

use App\Models\Property;
use App\Models\PropertyUser;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PropertyUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $properties = Property::all();
        $counter = 3;

        for($i = 0; $i <= $counter; $i++) {
            foreach ($properties as $key => $property) {
                $rand_user_id = rand(2,21);
                if(PropertyUser::all()->where('user_id', $rand_user_id)->count() > 1)
                    continue;
                PropertyUser::create([
                    'property_id' => $property->id,
                    'user_id'     => $rand_user_id,
                ]);
            }
        }

    }
}
