<?php

    namespace Database\Seeders;

    use App\Models\PropertyStatus;
    use App\Models\User;
    use Illuminate\Database\Console\Seeds\WithoutModelEvents;
    use Illuminate\Database\Seeder;

    class PropertyStatusSeeder extends Seeder
    {
        /**
         * Run the database seeds.
         */
        public function run(): void
        {
            $users = User::all();
            foreach ($users as $user) {
                foreach ($user->properties as $property) {
                    PropertyStatus::create([
                        'status_id' => rand(1, 2),
                        'property_id' => $property->id,
                        'user_id' => $user->id,
                        'approved' => true,
                    ]);
                }
            }
        }
    }
