<?php

namespace Database\Seeders;

use App\Models\Property;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PropertySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function __construct()
    {
        $this->properties = require 'database/PropertiesConfigFile/properties.php';
    }

    protected array $properties = [];

    public function run(): void
    {
        foreach ($this->properties as $property) {

            Property::create(
                [
                    'name'                  => $property['name'],
                    'main_img'              => $property['main_img'],
                    'gallery'               => $property['gallery'],
                    'description'           => $property['description'],
                    'square'                => $property['square'],
                    'property_category_id'  => $property['property_category_id'],
                ]
            );
        }
    }
}
