<?php

namespace Database\Seeders;

use App\Models\PropertyCategory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PropertyCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    private $objectCategories = [
        ['Апартаменты',  'Apartments'],
        ['Офисное помещение', 'office'],
    ];

    public function run(): void
    {
        foreach ($this->objectCategories as $category) {
            PropertyCategory::create([
                'name' => $category[0],
                'slug' => $category[1],
            ]);
        }
    }
}

