<?php

namespace Database\Seeders;

use App\Models\PropertyAdditionalStatuses;
use App\Models\PropertyStatus;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PropertyAdditionalStatusesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = User::all();
        $count = 1;

        for ($i=0; $i < $count; $i++) {
            foreach ($users as $user) {
                foreach ($user->properties as $property) {
                    if ($property->propertyStatusUser($user->id)->status->name == 'Владелец')
                        PropertyAdditionalStatuses::create([
                            'additional_status_id' => rand(1, 2),
                            'property_id' => $property->id,
                            'user_id' => $user->id,
                        ]);
                }
            }
        }
    }
}
