<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\Application;
use App\Models\Invoice;
use App\Models\Notification;
use App\Models\Property;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            CreateAdminSeeder::class,
            CreateCategoriesSeeder::class,
            CreateUsersSeeds::class,
        ]);
        Invoice::factory(500)->create();

        $this->call([
            CreateApplicationCategoriesSeeder::class,
            PropertyCategorySeeder::class,
            PropertySeeder::class,
        ]);
        Application::factory(350)->create();
        Notification::factory(350)->create();

        $this->call([
            PropertyUserSeeder::class,
            StatusesSeeder::class,
            AdditionalStatusSeeder::class,
            PropertyStatusSeeder::class,
            PropertyAdditionalStatusesSeeder::class,
        ]);
        // \App\Models\User::factory(10)->create();

        // \App\Models\User::factory()->create([
        //     'name' => 'Test User',
        //     'email' => 'test@example.com',
        // ]);
    }
}
