<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class CreateUsersSeeds extends Seeder
{
    /**
     * Run the database seeds.
     */
    private array $rolesList = [
        'individual',
        'entity',
    ];

    private function createUsers(int $count, string $type)
    {
        while ($count--) {
            $gender = fake()->randomElement(['male','female']);
            $user = User::create([
                'name'          => fake()->firstName($gender),
                'surname'       => fake()->lastName($gender),
                'middle_name'   => fake()->middleName($gender),
                'date_of_birth' => now(),
                'phone'         => fake()->phoneNumber,
                'avatar'        => asset('images/admin/empty.jpg'),
                'email'         => fake()->unique()->email(),
                'device'        => fake()->colorName(),
                'role'          => $this->rolesList[ array_rand($this->rolesList) ],
                'password'      => Hash::make('123456789'),
            ]);
            $user->createToken('API', [$type]);
        }
    }
    public function run(): void
    {
        $this->createUsers(10, 'individual');
        $this->createUsers(10, 'entity');
    }
}
