<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CreateCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    protected $categories = [
        ['Электричество', 'Оплата за использованную эл.энергию', 'electric', '/public/images/admin/categories/energy.png'],
        ['Газоснабжение', 'Оплата за использованный природный газ', 'gas', '/public/images/admin/categories/gas.png'],
        ['Водоснабжение', 'Оплата за поставку питьевой воды', 'water', '/public/images/admin/categories/water.png'],
        ['Содержание Ж/Ф', 'Оплата за содержание жилищного фонда', 'home_service', '/public/images/admin/categories/home-service.png'],
        ['Отопление', 'Оплата за центральное отопление помещений', 'heating', '/public/images/admin/categories/heat.png'],
        ['Вывоз мусора', 'Оплата за вывоз и переработку бытовых отходов', 'garbage', '/public/images/admin/categories/trash.png'],

    ];

    public function run(): void
    {
        foreach ($this->categories as $category) {
            Category::create(
                [
                    'name'          => $category[0],
                    'description'   => $category[1],
                    'slug'          => $category[2],
                    'categoryImage' => $category[3],
                ]
            );
        }
    }
}
