<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ApplicationCategory;

class CreateApplicationCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    private array $categories = [
        ['Уборка помещения', '/public/images/admin/ApplicationService/cleaning.svg'],
        ['Техническое обслуживание', '/public/images/admin/ApplicationService/tech.svg'],
        ['Вызов охраны', '/public/images/admin/ApplicationService/sec.svg'],
        ['Заказ пропуска', '/public/images/admin/ApplicationService/business-card-icon.svg'],
    ];

    public function run(): void
    {
        foreach ($this->categories as $category)

        ApplicationCategory::create([
            'name' => $category[0],
            'image' => $category[1],
        ]);
    }
}
