<?php

namespace Database\Seeders;

use App\Models\AdditionalStatus;
use App\Models\Status;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AdditionalStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    private array $statuses = [
        ['Продается', 'for sale'], ['Сдается', 'for rent'],
    ];

    public function run(): void
    {
        foreach ($this->statuses as $status) {
            AdditionalStatus::create([
                'name' => $status[0],
                'slug' => $status[1],
            ]);
        }

    }
}
