<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Notification>
 */
class NotificationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'title'   => fake()->realTextBetween(30, 50),
            'message' => fake()->realTextBetween(150, 200),
            'visited' => false,
            'user_id' => fake()->numberBetween(2,21),
        ];
    }
}
