<?php

namespace Database\Factories;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Invoice>
 */
class InvoiceFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $category_id = fake()->numberBetween(1,6);
        $category = Category::find($category_id);

        return [
            'sender' => 'ul13-service',
            'message' => $category->description,
            'amount' =>$this->faker->numberBetween(-3500, 3500),
            'period' => fake()->dateTimeBetween('now', '+10 days')->format('d.m.Y') . '-'
                . fake()->dateTimeBetween('now', '+45 days')->format('d.m.Y'),
            'resourceValue' => fake()->numberBetween(100, 500),
            'unit' => 'kW',
            'user_id' =>  strval(rand(2,21)),
            'category_id' => $category_id,
        ];
    }
}
