<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class ApplicationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {

        return [
            'user_id' => fake()->numberBetween(2,21),
            'application_category_id' => fake()->numberBetween(1,3),
            'property_id' => fake()->numberBetween(1, 16),
            'message'   => fake()->realText(),
            'status'    => fake()->randomElement(['Обработка', 'Новая', 'Принята', 'Выполнена', 'Отменена']),
            'due_date'  => fake()->dateTimeBetween('now', '+15 days')->format('d-m-Y H:m'),
            'priority'  => fake()->randomElement(['Высокий', 'Средний', 'Низкий']),
            'delivered' => false,
            'visited'   => false,
        ];
    }
}
