<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PropertyAdditionalStatuses extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function additionalStatus(): BelongsTo
    {
        return $this->belongsTo(AdditionalStatus::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

}
