<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use PhpParser\Node\Expr\Cast\Object_;
use Ramsey\Collection\Collection;

class Property extends Model
{
    use HasFactory;

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'property_users');
    }

    public function applications(): HasMany
    {
        return $this->hasMany(Application::class);
    }

    public function propertyStatuses(): HasMany
    {
        return $this->hasMany(PropertyStatus::class, 'property_id');
    }

    public function propertyAdditionalStatuses(): HasMany
    {
        return $this->hasMany(PropertyAdditionalStatuses::class, 'property_id');
    }

    public function propertyRequests()
    {
        return $this->propertyStatuses()->where('approved', 0)->get();
    }

    public function propertyRequestsCount()
    {
        return $this->propertyStatuses()->where('approved', 0)->count();
    }

    public function propertyStatusUser($user_id)
    {
        return $this->propertyStatuses()->where('user_id', $user_id)->get()->first();
    }

    public function propertyAdditionalStatusesUser($user_id): \Illuminate\Database\Eloquent\Collection
    {
        return $this->propertyAdditionalStatuses()->where('user_id', $user_id)->get();
    }

    public function propertyCategory(): BelongsTo
    {
        return $this->belongsTo(PropertyCategory::class);
    }

}
