<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use App\Models\ApplicationCategory;
use App\Models\User;

class Application extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function applicationCategory():BelongsTo
    {
        return $this->belongsTo(ApplicationCategory::class);
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function property(): BelongsTo
    {
        return $this->belongsTo(Property::class);
    }
}
