<?php

    namespace App\Http\Lib;

    use Illuminate\Http\Request;
    use Laravel\Sanctum\PersonalAccessToken;

    trait ApiAuthHelper
    {
        protected function updateExpiresTime(Request $request): PersonalAccessToken
        {
            $token = PersonalAccessToken::findToken($request->bearerToken());
            $token->expires_at = now()->addMinutes(5);
            $token->save();

            return $token;
        }

        protected function apiResponse(bool $status, string $message, mixed $errors = '', mixed $token = '', mixed $user = '', int $statusCode = 200)
        {

            return response()->json([
                'status' => $status,
                'message' => $message,
                'errors' => $errors,
                'token' => $token,
                'user' => $user,
                'statusCode' => $statusCode,

            ], $statusCode);
        }

        protected function isAdmin($user): bool
        {
            if (!empty($user)) {
                return $user->tokenCan('admin');
            }
            return false;
        }

        protected function isIndividual($user): bool
        {
            if (!empty($user)) {
                return $user->tokenCan('individual');
            }
            return false;
        }

        protected function isEntity($user): bool
        {
            if (!empty($user)) {
                return $user->tokenCan('entity');
            }
            return false;
        }

    }
