<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    public function index()
    {
        $users = User::all();
        return view('admin.users.index',compact('users'));

    }

    public function destroy($id, Request $request)
    {
        $user = User::find($id);
        if($user->role != 'admin') {
            $user->tokens()->delete();
            $user->delete();
            return redirect()->route('users.index')->with('success', 'Пользователь был успешно удален');
        }

        return redirect()->route('users.index')->with('error', 'Нельзя удалить администратора!');

    }

    public function saveFcmToken(Request $request)
    {
        $currentUser = User::find($request->user_id);
        $currentUser->FCM_token = $request->token;
        $currentUser->save();

        return response('fcm saved!');
    }

    public function update_API(Request $request)
    {
        $fileName='';

        $validate = Validator::make($request->all(),
        [
            'name' => 'required|string|max:255',
            'middlename' => 'required|string|max:255',
            'surname' => 'required|string|max:255',
            'email' => 'required|email',
            'phone' => 'required|max:20',
        ]);

        if($validate->fails()) {
            return response()->json(['message' => 'Некоторые поля пусты либо содержат некорректные данные!', 'status'=> 'Fail'], 500);
        }


        if($request->avatar != '' && str_starts_with($request->avatar, 'data:')) {
            $exploded = explode(',', $request->avatar);
            $decoded = base64_decode($exploded[1]);
            $exploded = explode('/', $exploded[0]);
            $exploded = explode(';', $exploded[1]);
            $extension = $exploded[0];
            $fileName = base64_encode(now() . rand(0, 1000)) . '.' . $extension;
            $path = public_path('storage/images/') . $fileName;
            file_put_contents($path, $decoded);
        }

        $user = User::find($request->id);
        $user->name = $request->name;
        $user->surname = $request->surname;
        $user->middle_name = $request->middlename;
        $user->phone = $request->phone;
        $user->email = $request->email;
        $user->avatar = $fileName != '' ? asset('/storage/images') . '/' . $fileName : $request->avatar;

        $user->save();

        return response()
            ->json(['message' => 'Данные были успешно обновлены', 'status'=> 'success'], 200);
    }

    public function passwordChange_API(Request $request)
    {
        $user = User::find($request->user_id);

        if(\Hash::check($request->password, $user->password)) {
            $user->password = \Hash::make($request->newPassword);
            $user->save();
            return response()->json(true);
        }

        return response()
            ->json([
                'message' => 'Введен неправильный пароль. Проверьте корректность данных!', 'status' =>'fail'
            ], 500);

    }
}
