<?php

namespace App\Http\Controllers;

use App\Models\Application;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Http\Services\NotificatorApi;
use Illuminate\Support\Facades\Log;

class ServiceApplicationsController extends Controller
{
    public function index()
    {
        $applications = Application::orderBy('updated_at', 'desc')->paginate(50);
        $statuses = ['Новая', 'Обработка', 'Принята', 'Изменена', 'Отменена', 'Выполнена' ];
        $priorities = ['Высокий', 'Средний','Низкий'];

        return view('admin.service.index', compact('applications', 'statuses', 'priorities'));
    }

    public function destroy($id)
    {
        Application::destroy($id);
        return redirect()->route('services-applications.index')->with('success','Заявка была успешно удалена');
    }

    public function update(Request $request, $id)
    {

        $application = Application::find($id);
        $clientToken = '';

        $notificationFlag = $application->status != $request->input('status');
        $oldStatus = $application->status;

        $application->application_category_id = $request->input('category_id');
        $application->message = $request->input('message');
        $application->due_date = $request->input('due_date');
        $application->status = $request->input('status');
        $application->priority = $request->input('priority');
        $application->save();

        if($notificationFlag) {
            $clientToken = $application->user->FCM_token;

            if (!$clientToken) {
                Log::warning('Статус заявки был изменен, но без службы Push т.к пользователь запретил ее использование');
                return redirect()->route('services-applications.index')->with('warning', 'Заявка #UL' .$id. ' была успешно изменена,
                 но неудалось отправить Push уведомление на устройство. Возможно пользователь запретил Push уведомления или возникла ошибка на сервере');
            }

            $notification = new NotificatorApi();

            $pushTitle = 'Ваша заявка #UL' .$application->id. 'обновлена';

            $pushMessage = 'Уважаемый(ая), ' . $application->user->name . ' ' . $application->user->middle_name . ', статус вашего 
                            обращения был изменен c ' . '«' . $oldStatus . '»' . ' на ' . '«' . $request->input('status') . '»';

            $notification->sendNotification(
                $pushTitle, $pushMessage, $clientToken);
            Log::info('Статус заявки был успешно изменен. Пользователь был уведомлен через службы Push!');
            return redirect()
                ->route('services-applications.index')
                ->with('success', 'Заявка #UL' .$id. ' была успешно изменена! Push уведомление будет доставлено на устройство пользователя в ближайшее время');
        }
        return true;
    }

    public function acceptApplicationFromSidePanel(Request $request)
    {
        $application = Application::find($request->application_id);
        $oldStatus = $application->status;
        $application->status = 'Принята';
        $application->save();

        $notification_to_app = Notification::create([
            'title'     => 'Ваша заявка #UL' .$application->id. ' обновлена',
            'message'   => 'Уважаемый(ая), ' . $application->user->name . ' ' . $application->user->middle_name . ', статус вашего обращения был изменен c ' . '«' . $oldStatus . '»' . ' на ' . '«Принята»',
            'sent'      => true,
            'visited'   => false,
            'user_id'   => $application->user->id,

        ]);
        $notification_to_app->save();

        $clientToken = $application->user->FCM_token;
        if (!$clientToken) {
            Log::warning('Статус заявки был изменен на "Принята", но без службы Push т.к пользователь запретил ее использование');
            return redirect()->route('dashboard')->with('warning', 'Статус заявки #UL ' .$request->application_id. ' был успешно изменен на "Принята",
                 но неудалось отправить Push уведомление на устройство. Возможно пользователь запретил Push уведомления или возникла ошибка на сервере');
        }

        $notification = new NotificatorApi();
        $pushTitle = 'Ваша заявка #UL' .$application->id. 'обновлена';

        $pushMessage = 'Уважаемый(ая), ' . $application->user->name . ' ' . $application->user->middle_name . ', статус вашего 
                            обращения был изменен c ' . '«' . $oldStatus . '»' . ' на ' . '«Принята»';

        $notification->sendNotification(
            $pushTitle, $pushMessage, $clientToken);
        Log::info('Статус заявки #UL' . $application->id . 'был успешно изменен на «Принята». Пользователь был уведомлен через службы Push!');

        return redirect()
            ->route('dashboard')
            ->with('success', 'Заявка #UL' .$request->application_id. ' была успешно изменена! Push уведомление будет доставлено на устройство пользователя в ближайшее время');

    }

    public function cancelApplicationFromSidePanel(Request $request)
    {
        $application = Application::find($request->application_id);
        $oldStatus = $application->status;
        $application->status = 'Отменена';
        $application->save();

        $notification_to_app = Notification::create([
            'title'     => 'Ваша заявка #UL' .$application->id. ' обновлена',
            'message'   => 'Уважаемый(ая), ' . $application->user->name . ' ' . $application->user->middle_name . ', статус вашего обращения был изменен c ' . '«' . $oldStatus . '»' . ' на ' . '«Отменена».  Пожалуйста, свяжитесь с нами для уточнения деталей.',
            'sent'      => true,
            'visited'   => false,
            'user_id'   => $application->user->id,

        ]);
        $notification_to_app->save();
        $clientToken = $application->user->FCM_token;
        if (!$clientToken) {
            Log::warning('Статус заявки был изменен на "Отменена", но без службы Push т.к пользователь запретил ее использование');
            return redirect()->route('dashboard')->with('warning', 'Статус заявки #UL ' .$request->application_id. ' был изменен на "Отменена",
                 но неудалось отправить Push уведомление на устройство. Возможно пользователь запретил Push уведомления или возникла ошибка на сервере');
        }

        $notification = new NotificatorApi();
        $pushTitle = 'Ваша заявка #UL' .$application->id. 'обновлена';

        $pushMessage = 'Уважаемый(ая), ' . $application->user->name . ' ' . $application->user->middle_name . ', статус вашего 
                            обращения был изменен c ' . '«' . $oldStatus . '»' . ' на ' . '«Отменена». Пожалуйста, свяжитесь с нами для уточнения деталей.';

        $notification->sendNotification(
            $pushTitle, $pushMessage, $clientToken);
        Log::info('Статус заявки #UL' . $application->id . 'был успешно изменен на «Принята». Пользователь был уведомлен через службы Push!');
        return redirect()
            ->route('home.index')
            ->with('success', 'Заявка #UL' .$request->application_id. ' была успешно изменена! Push уведомление будет доставлено на устройство пользователя в ближайшее время');
    }

    public function deleteApplicationFromSidePanel(Request $request)
    {
        $application = Application::find($request->application_id);
        $application->delete();
        return redirect()
            ->route('home.index')
            ->with('success', 'Заявка #UL' .$request->application_id. ' была успешно удалена!');
    }
}
