<?php

namespace App\Http\Controllers;

use App\Http\Services\NotificatorApi;
use App\Models\AdditionalStatus;
use App\Models\Property;
use App\Models\PropertyAdditionalStatuses;
use App\Models\PropertyStatus;
use App\Models\PropertyUser;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PropertyController extends Controller
{
    public function index()
    {
        $properties = Property::all();
        return view('admin.property.index', compact('properties'));

    }

    public function show($id)
    {
        $property = Property::find($id);
        return view('admin.property.show', compact('property'));
    }

    public function deleteUserStatusesFromProperty($user_id, $property_id)
    {
        $propertyUser = PropertyUser::where('property_id',$property_id)->where('user_id', $user_id);
        $propertyUser->delete();

        $propertyUserStatuses = PropertyStatus::where('property_id',$property_id)->where('user_id', $user_id);
        $propertyUserStatuses->delete();

        $propertyAdditionalStatuses = PropertyAdditionalStatuses::where('property_id',$property_id)->where('user_id', $user_id);
        $propertyAdditionalStatuses->delete();

        foreach ($propertyAdditionalStatuses as $status) {
            $status->delete();
        }

        return redirect()->route('property.show', $property_id)->with('success', 'Данные пользователя были удалены из объекта');
    }

    public function acceptRequest($id)
    {
       $propertyStatus = PropertyStatus::find($id);
       $user = User::find($propertyStatus->user->id);
       $clientToken = $user->FCM_token;

       $property_id = $propertyStatus->property_id;
       $propertyStatus->approved = 1;
       $propertyStatus->save();

        if(!$clientToken) {
            Log::info('Объект' . $propertyStatus->property->description . ' ' . $propertyStatus->property->name . ' был успешно добавлен пользователем' . 'ID#' . $user->id . 'без PUSH службы');
            return redirect()->route('property.show', (int)$property_id)->with('warning','Заявка пользователя была успешно одобрена, но без службы Push т.к пользователь запретил ее использование');
        }
        $notification = new NotificatorApi();

        $pushTitle   = 'Новый объект был добавлен!';
        $pushMessage = 'Объект' . $propertyStatus->property->description . ' ' . $propertyStatus->property->name . ' был успешно добавлен! Спасибо за ваше терпение!';
        $notification->sendNotification(
            $pushTitle, $pushMessage, $clientToken);
        Log::info('Объект' . $propertyStatus->property->description . ' ' . $propertyStatus->property->name . ' был успешно добавлен пользователем' . 'ID#' . $user->id);
       return redirect()->route('property.show', (int)$property_id)->with('success', 'Заявка пользователя была успешно одобрена. Пользователь получить Push уведомление.');
    }

    public function addNewUser(Request $request)
    {
        $userId              = $request->user_id;
        $propertyId          = $request->property_id;
        $mainStatusId        = $request->main_status_id;
        $additionalStatusIds = $request->additional_statuses;

        $propertyUser = PropertyUser::where('property_id', $propertyId)->where('user_id', $userId)->get();
        if(count($propertyUser) > 0) {
            return redirect()->route('property.show', $propertyId)->with('error', 'Данный объект уже связан с выбранным вами пользователем');
        }

// Добавляем пользователя в объект
        PropertyUser::create([
            'user_id'     => $userId,
            'property_id' => $propertyId,
        ]);

// Присваиваем основной статус
        PropertyStatus::create([
            'status_id'     => $mainStatusId,
            'property_id'   => $propertyId,
            'user_id'       => $userId,
            'approved'      => true,
        ]);

// Присваиваем дополнительный статус
        if($additionalStatusIds != null) {
            foreach ($additionalStatusIds as $statusId) {
                PropertyAdditionalStatuses::create([
                    'additional_status_id' => $statusId,
                    'property_id' => $propertyId,
                    'user_id' => $userId,
                ]);
            }
        }
       return redirect()->route('property.show', $propertyId)->with('success', 'Объект был успешно связан с пользователем');
    }
}
