<?php

namespace App\Http\Controllers;

use App\Http\Services\NotificatorApi;
use App\Models\Notification;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;

class NotificationController extends Controller
{
    public function index()
    {
        $notifications = Notification::orderBy('id', 'desc')->orderBy('updated_at', 'desc')->paginate(50);
        $users = User::all();
        return view('admin.notifications.index', compact('notifications', 'users'));
    }


    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'title' => 'required|max:255|string',
            'message' => 'required|string',
            'user_id' => 'required'
        ]);

        $user = User::find($request->input('user_id'));
        $clientToken = $user->FCM_token;

        Notification::create([
            'title'   => $request->input('title'),
            'message' => $request->input('message'),
            'user_id' => $request->input('user_id'),
            'sent'    => (bool)$clientToken,
        ]);

        $prev_name = Route::getRoutes()->match(request()->create(url()->previousPath()))->getName();
        $params = $prev_name === 'notifications.index' ? '' : $user->id;

        if(!$clientToken) {

            return redirect()->route($prev_name, $params)->with('warning','Уведомление было успешно отправлено, но без службы Push т.к пользователь запретил ее использование');
        }

        $notification = new NotificatorApi();

        $pushTitle   = $request->input('title');
        $pushMessage = mb_strimwidth($request->input('message'),0, 150, '...' );

        $notification->sendNotification(
            $pushTitle, $pushMessage, $clientToken);

        Log::info('Уведомление было успешно отправлено с использованием службы Push!');

        return redirect()->route($prev_name, $params)->with('success', 'Уведомление было успешно отправлено! 
            Push уведомление будет доставлено на устройство пользователя в ближайшее время');

    }

    public function destroy($id)
    {
        $notification = Notification::find($id);
        $userId = $notification->user->id;
        Notification::destroy($id);
        $prev_name = Route::getRoutes()->match(request()->create(url()->previousPath()))->getName();
        if($prev_name === "notifications.index") {
            return redirect()->route('notifications.index')->with('success', 'Уведомление было удалено');
        }
        return redirect()->route('notifications.user', $userId)->with('success', 'Уведомление было удалено');
    }

    public function getNotificationsByUserId($id)
    {
        $user = User::find($id);
        $notifications = $user->notifications()->orderBy('updated_at', 'desc')->paginate(50);
        return view('admin.notifications.notificationsByUser', compact('notifications', 'user'));
    }

    public function edit(Request $request)
    {
        $notification = Notification::find($request->notification_id);
        $notification->user_id = $request->user_id;
        $notification->title = $request->title;
        $notification->message = $request->message;
        $notification->save();
        return redirect()->route('notifications.index')->with('success', 'Уведомление было изменено');

    }
}
