<?php

    namespace App\Http\Controllers;

    use App\Models\Category;
    use App\Models\Invoice;
    use App\Models\Notification;
    use App\Models\User;
    use App\Http\Services\NotificatorApi;

    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Log;
    use SebastianBergmann\CliParser\Exception;

    class InvoiceController extends Controller
    {


        public function index()
        {

            $users = User::orderBy('id', 'desc')->paginate(16);

            return view('admin.invoices.index', compact('users'));
        }

        public function create()
        {
            $users = User::all();
            $categories = Category::all();
            return view('admin.invoices.create', compact('users', 'categories'));
        }

        public function store(Request $request)
        {

            Invoice::create([
                'sender' => $request->input('sender'),
                'message' => $request->input('message'),
                'amount' => $request->input('amount'),
                'resourceValue' => $request->input('resourceValue'),
                'unit' => $request->input('unit'),
                'period' => $request->input('period'),
                'user_id' => $request->input('user_id'),
                'category_id' => $request->input('category_id'),
            ]);

            if(!$request->input('push-checkbox')) {
                return redirect()->route('invoice.create')->with('success', 'Счет был успешно отправлен без Push уведомления');
            }


            $user = User::find($request->input('user_id'));
            $clientToken = $user->FCM_token;

            if (!$clientToken) {
                Log::warning('Уведомление было отправлено, но без службы Push т.к пользователь запретил ее использование');
                return redirect()->route('invoice.create')->with('warning', 'Счет был успешно отправлен,
                 но неудалось отправить Push уведомление на устройство. Возможно пользователь запретил Push уведомления или возникла ошибка на сервере');
            }

            $notification = new NotificatorApi();

            $pushTitle   = $request->input('push-title') != '' ? $request->input('push-title') : 'Ваши счета были обновлены!';

            $pushMessage = $request->input('push-message') != '' ?
                mb_strimwidth( $request->input('push-message'), 0, 150, '...') :
                mb_strimwidth($request->message, 0, 150, '...');

            $notification->sendNotification(
                $pushTitle, $pushMessage, $clientToken);
            Log::info('Инвойс был успешно отправлен с использованием службы Push!');
            return redirect()->route('invoice.create')->with('success', 'Счет был успешно отправлен! 
            Push уведомление будет доставлено на устройство пользователя в ближайшее время');

        }

    }
