<?php

namespace App\Http\Controllers;

use App\Models\Application;
use App\Models\Invoice;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $invoices = Invoice::orderBy('updated_at', 'desc')->paginate(20);
        $applications = Application::where('status','!=','Выполнена')->where('status','!=','Отменена')->orderBy('updated_at', 'desc')->paginate(20);

        return view('home', compact('invoices', 'applications'));
    }
}
