<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use App\Models\User;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function getNotifications(Request $request)
    {
        $user = User::find($request->id);
        $notifications = $user->notifications()->orderBy('visited', 'asc')->orderBy('updated_at', 'desc')->get();
        return response()->json($notifications);
    }

    public function getNotificationById($id)
    {
        $notification = Notification::find($id);
        return response()->json($notification);
    }

    public function getNotificationsCount(Request $request)
    {
        $user = User::find($request->id);
        $count = $user->notifications()->where('visited', 0)->count();
        return response()->json($count);
    }

    public function setVisited(Request $request)
    {
        $notification = Notification::find($request->id);
        $notification->visited = true;
        $notification->save();
    }

    public function destroy(Request $request)
    {
        Notification::destroy($request->id);
    }
}
